package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.site.model.Content;
import itez.plat.site.service.ContentService;

import java.util.Date;
import java.util.List;

import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Page;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ContentServiceImpl extends EModelService<Content> implements ContentService {

	public List<Content> getByChannelId(String channelId){
		return getByChannelId(channelId, null);
	}
	
	public List<Content> getByChannelId(String channelId, Integer limit){
		return getByChannelId(channelId, limit, true);
	}
	
	public List<Content> getByChannelId(String channelId, Integer limit, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc")).setLimit(limit);
		return select(selector);
	}
	
	public List<Content> getByChannelIds(List<String> channelIds, Integer limit, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids)));
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc")).setLimit(limit);
		return select(selector);
	}
	
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc"));
		return paginate(pageNum, pageSize, selector);
	}
	
	public Page<Content> getPageByChannelIds(List<String> channelIds, Integer pageNum, Integer pageSize, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids)));
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc"));
		return paginate(pageNum, pageSize, selector);
	}
	
	public List<Content> searchByChannelId(String channelId, String keyword, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(Query.like("caption", "%" + keyword + "%"));
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc"));
		return select(selector);
	}
	
	public List<Content> searchByChannelIds(List<String> channelIds, String keyword, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids))).add(Query.like("caption", "%" + keyword + "%"));;
		Selector selector = Selector.select().where(qs).orderBy("mdate " + (desc ? "desc" : "asc"));
		return select(selector);
	}
	
	public Content first(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		return selectFirst(qs, "mdate");
	}
	
	public Content last(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		return selectFirst(qs, "mdate desc");
	}
	
	public Content next(String channelId, Date mdate){
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(Query.gt("mdate", mdate));
		return selectFirst(qs, "mdate");
	}
	
	public Content previous(String channelId, Date mdate){
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(Query.lt("mdate", mdate));
		return selectFirst(qs, "mdate desc");
	}

}