package itez.plat.site.service.impl;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.core.runtime.service.Define;
import itez.plat.site.SiteConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;
import itez.plat.wrapper.service.ETreeService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ChannelServiceImpl extends ETreeService<Channel> implements ChannelService {

	public Channel createIndexChannel(){
		Channel channel = new Channel();
		channel.setCode(SiteConfig.INDEX_CODE);
		channel.setIcon("fa fa-home");
		channel.setPic("");
		channel.setCaption("网站首页");
		channel.setContent("");
		channel.setPath("001");
		channel.setSort(1);
		channel.setChannelTemp("index.html");
		channel.setContentTemp("content.html");
		super.save(channel);
		return channel;
	}
	
	public Channel getIndexChannel(){
		Channel channel = super.findByCode(SiteConfig.INDEX_CODE);
		if(channel == null) channel = createIndexChannel();
		return channel;
	}
	
	public List<Channel> getAllChannels(){
		Querys qs = Querys.and(Query.nn("pid"));
		return select(qs, "path", null);
	}
	
	public List<Channel> getTreeChannels(){
		Querys qs = Querys.and(Query.nn("pid"));
		Selector selector = Selector.select("id, pid, code, icon, pic, caption, subCaption, path").where(qs).orderBy("path");
		return select(selector);
	}
	
	public void addChannel(Channel channel){
		super.save(channel);
	}
	
	public void modifyChannel(Channel channel){
		super.update(channel);
	}
	
	public void removeChannels(String ids){
		super.deleteByIds(ids);
	}

	public Channel getLastChannel(String pid){
		return super.getLast(pid);
	}
	
	public void sort(String pid, String opt, String ids){
		super.sort(pid, opt, ids);
	}
	
	public List<Channel> getChildren(String id){
		Querys qs = Querys.and(Query.eq("pid", id));
		return select(qs, "sort", null);
	}
	
	public List<String> getChildrenIds(String id){
		Channel parent = findById(id);
		Querys qs = Querys.and(Query.like("path", parent.getPath() + "%"));
		return selectCol(qs, "id");
	}
	
}