package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.template.Engine;

import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EControllerSite;
import itez.kit.EStr;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.service.SiteTempService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/temp", summary = "网站模板", view = "/")
public class SiteTempController extends EControllerMgr {

	@Inject
	SiteTempService tempSer;
	
	public void index(){
		List<SiteTemp> temps = tempSer.getTemps();
		setAttr("temps", temps);
		render("temp.html");
	}
	
	public void init(){
		tempSer.init();
		redirect(attr().getCtrl());
	}
	
	public void del(){
		String fileName = getPara("fileName");
		boolean does = tempSer.del(fileName);
		if(!does) setFlashMsg("删除失败！");
		else clearTemp(fileName);
		redirect(attr().getCtrl());
	}
	
	public void saveas(){
		String fromName = getPara("f");
		String toName = getPara("t");
		tempSer.saveas(fromName, toName);
		redirect(attr().getCtrl());
	}
	
	public void edit(){
		String fileName = getPara("fileName");
		String act;
		SiteTemp temp;
		if(EStr.isEmpty(fileName)){
			act = "create";
			temp = new SiteTemp();
			temp.setFileName("new.html");
			temp.setSpace(0L);
			temp.setContent("<html></html>");
		}else{
			act = "modify";
			temp = tempSer.getTemp(fileName);
		}
		setAttr("act", act);
		setAttr("temp", temp);
		render("tempContent.html");
	}
	
	public void editDo(){
		String act = getPara("act");
		String fileName = getPara("fileName");
		String content = getPara("content");
		SiteTemp temp = new SiteTemp();
		temp.setFileName(fileName);
		temp.setContent(content);
		if(act.equals("create")){
			tempSer.create(temp);
		}else if(act.equals("modify")){
			tempSer.modify(temp);
		}
		clearTemp(fileName);
		redirect(attr().getCtrl());
	}
	
	private void clearTemp(String view){
		String viewPath = "/" + attr().getDomain() + "/" + view;
		Engine engine = EControllerSite.getEngine();
		try {
			engine.removeTemplateCache(viewPath);
		} catch (Exception e) {
			System.out.println("模板缓存不存在！");
		}
	}
	
}
