package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.site.model.Navi;
import itez.plat.site.service.NaviService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/navi", summary = "网站导航", view = "/")
public class SiteNaviController extends EControllerMgr {
	
	@Inject
	NaviService naviSer;

	public void index(){
		List<Navi> navis = naviSer.findByDomain();
		setAttr("navis", navis);
		render("navi.html");
	}
	
	public void addNavi(){
		Navi navi = getBean(Navi.class, "");
		naviSer.save(navi);
		redirect(attr().getCtrl());
	}
	
	public void modifyNavi(){
		Navi naviNew = getBean(Navi.class, "");
		Navi navi = naviSer.findById(naviNew.getId());
		navi._setAttrs(naviNew);
		naviSer.update(navi);
		redirect(attr().getCtrl());
	}
	
	public void removeNavi(){
		String ids = getPara("ids");
		naviSer.deleteByIds(ids);
		redirect(attr().getCtrl());
	}
	
}
