package itez.plat.site.controller;

import com.google.inject.Inject;
import com.jfinal.render.RenderManager;

import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/info", summary = "网站基本信息", view = "/")
public class SiteInfoController extends EControllerMgr {
	
	@Inject
	InfoService infos;

	/**
	 * 网站基本信息
	 */
	public void index(){
		Info info = infos.getInfo();
		setAttr("info", info);
		render("info.html");
	}
	
	/**
	 * 更新网站基本信息
	 */
	public void modify(){
		String caption = getPara("caption");
		String subCaption = getPara("subCaption");
		String welcome = getPara("welcome");
		Info info = infos.getInfo();
		info.setCaption(caption);
		info.setSubCaption(subCaption);
		info.setWelcome(welcome);
		infos.modifyInfo(info);
		setFlashMsg("修改成功！");
		redirect(attr().getCtrl());
	}

	public void updateTemp(){
		String fileName = "";
		RenderManager.me().getEngine().removeTemplateCache(fileName);
	}
	
}
