package itez.plat.msg.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.core.runtime.service.Define;
import itez.plat.msg.model.Subject;
import itez.plat.msg.model.User;
import itez.plat.msg.service.MsgType;
import itez.plat.msg.service.ReciveService;
import itez.plat.msg.service.SubjectService;
import itez.plat.msg.service.UserService;
import java.util.Date;
import java.util.List;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserServiceImpl extends EModelService<User> implements UserService {

	@Inject
	SubjectService subjectSer;
	
	@Inject
	ReciveService reciveSer;
	
	public Integer getUnreadCount(String uid, String uname){
		generSysMsg(uid, uname);
		return getUnreadCountRel(uid);
	}
	
	public Page<Record> getUnreadList(String uid){
		return getUnreadList(uid, null);
	}
	
	public Page<Record> getUnreadList(String uid, MsgType mtype){
		return getUnreadList(uid, mtype, 1);
	}
	
	public Page<Record> getUnreadList(String uid, MsgType mtype, Integer pageNum){
		Kv paras = Kv.by("uid", uid);
		if(mtype != null) paras.set("mtype", mtype.getValue());
		SqlPara sqlPara = dbo().getSqlPara("getUnreadList", paras);
		return dbo().paginate(pageNum, 20, sqlPara);
	}
	
	public void generSysMsg(String uid, String uname){
		User user = getUserStatus(uid);
		Date lastSys = subjectSer.getLastSysMsg();
		if(lastSys == null) return; //还未发布过系统消息
		if(user.getLastDate().before(lastSys)) return; //自从上次处理之后，未发布新的系统消息
		List<Subject> subjects = subjectSer.getNewSysMsg(user.getLastDate()); //获取新的系统消息
		if(subjects == null || subjects.size() == 0) return;
		for(Subject subject : subjects){
			reciveSer.generSysMsg(subject.getId(), user.getUserId(), uname);
		}
		setUserStatus(user, subjects.size());
	}
	
	public Integer getUnreadCountRel(String uid){
		return reciveSer.getUnreadCountRel(uid);
	}
	
	public User getUserStatus(String uid){
		Querys qs = Querys.and(Query.eq("userId", uid));
		User us = selectFirst(qs);
		if(us == null){
			us = new User().setUserId(uid).setLastDate(EDate.getDate());
			save(us);
		}
		return us;
	}
	
	public void setUserStatus(User us, Integer unread){
		us.setLastDate(EDate.getDate());
		update(us);
	}

}