package itez.plat.base.service.impl;

import itez.core.runtime.session.EAttr;
import itez.core.wrapper.controller.EController;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Menu;
import itez.plat.base.service.MenuService;
import itez.plat.wrapper.service.ETreeService;

import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.google.inject.Singleton;
import com.jfinal.aop.Invocation;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class MenuServiceImpl extends ETreeService<Menu> implements MenuService {
	
	@Override
	public Menu findById(String id) {
		return super.findById(id);
	}

	public List<Menu> getCompMenus(String mtype){
		return getCompMenus(mtype, null);
	}

	public List<Menu> getCompMenus(String mtype, String pid){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		qs.add(pid == null ? Query.nu("pid") : Query.eq("pid", pid));
		List<Menu> menus = select(Selector.select().where(qs));
		if(pid == null && (menus == null || menus.size() == 0)) menus = initMenu(mtype);
		menus.forEach(menu -> {
			if(menu.getFolder() == 1){
				List<Menu> subs = getCompMenus(mtype, menu.getId());
				if(null != subs && subs.size() > 0){
					menu.put("subs", subs);
				}
			}
		});
		return menus;
	}
	
	/**
	 * 初始化最基本的菜单
	 * @param mtype
	 * @return
	 */
	public List<Menu> initMenu(String mtype){
		List<Menu> menus = Lists.newArrayList();
		if(mtype.equals("menu")){
			//平台首页
			Menu indexMenu = new Menu();
			indexMenu.setMtype(mtype).setIco("fa fa-circle-o").setCaption("平台首页").setCommand("src:/plat").setPath("001").setFolder(0).setSort(1);
			save(indexMenu);
			menus.add(indexMenu);
			//系统设置
			Menu sysMenu = new Menu();
			sysMenu.setMtype(mtype).setIco("fa fa-cogs").setCaption("系统设置").setPath("002").setFolder(1).setSort(2);
			save(sysMenu);
			menus.add(sysMenu);
			//单位信息
			Menu compMenu = new Menu();
			compMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-bank").setCaption("单位信息").setCommand("src:/plat/comp").setPath("002_001").setFolder(0).setSort(1);
			save(compMenu);
			//部门管理
			Menu deptMenu = new Menu();
			deptMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-sitemap").setCaption("部门管理").setCommand("src:/plat/dept").setPath("002_002").setFolder(0).setSort(2);
			save(deptMenu);
			//成员管理
			Menu userMenu = new Menu();
			userMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-user-o").setCaption("成员管理").setCommand("src:/plat/insUser").setPath("002_003").setFolder(0).setSort(3);
			save(userMenu);
			//菜单管理
			Menu menuMenu = new Menu();
			menuMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-bars").setCaption("侧栏菜单管理").setCommand("src:/plat/menu?mtype=menu").setPath("002_004").setFolder(0).setSort(4);
			save(menuMenu);
			//导航管理
			Menu naviMenu = new Menu();
			naviMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-map-signs").setCaption("顶部导航管理").setCommand("src:/plat/menu?mtype=navi").setPath("002_005").setFolder(0).setSort(5);
			save(naviMenu);
		}
		return menus;
	}

	public List<Menu> getMenuTree(String mtype){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		return select(qs, "path");
	}
	
	public Menu getLastMenu(String mtype, String pid){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		return super.getLast(qs, pid);
	}
	
	public void sort(String mtype, String pid, String opt, String ids){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		super.sort(qs, pid, opt, ids);
	}
	
	public void interceptorMenu(Invocation inv, String mtype){
		EController controller = (EController)inv.getController();
		EAttr attr = EContext.getAttr();
		
		final String menuActiveKey = "_m_";
		
		String clickMenu = controller.getPara(menuActiveKey);
		
		if(EStr.notEmpty(clickMenu)){
			if(clickMenu.equals("_index_")) clickMenu = "";
			EContext.getSession().setAttribute(menuActiveKey, clickMenu);
		}else{
			clickMenu = EContext.getSession().getAttr(menuActiveKey);
		}
		
		if(EStr.notEmpty(clickMenu)){
			int at = clickMenu.lastIndexOf("_");
			at = at == -1 ? 0 : at+1;
			String menuId = clickMenu.substring(at);
			String menuActiveName = findById(menuId).getCaption();
			attr.setItem("currentMenuId", clickMenu);
			attr.setItem("currentMenuName", menuActiveName);
			attr.setItem("currentMenuStr", String.format("%s=%s", menuActiveKey, clickMenu));
		}
		
		List<Menu> menus = getCompMenus(mtype);
		if(menus != null) attr.setItem("menusData", menus);
	}

}