package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Selector;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Dict;
import itez.plat.base.service.DictService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DictServiceImpl extends EModelService<Dict> implements DictService {

	/**
	 * 检索指定分组的条目列表
	 * @param groupCode
	 * @return
	 */
	public List<Dict> getByGroup(String groupCode){
		Selector selector = Selector.select().where(Query.eq("groupCode", groupCode)).orderBy("sort");
		return select(selector);
	}
	
	@Override
	@Cache.able(key="#(code)")
	public Dict findByCode(String code){
		return super.findByCode(code);
	}
	
	@Override
	@Cache.del(key="#(model.code)")
	public boolean save(Dict model) {
		return super.save(model);
	}
	
	@Override
	@Cache.del(key="#(model.code)")
	public boolean update(Dict model) {
		return super.update(model);
	}
	
	@Override
	@Cache.del(keys="#(codes)")
	public boolean deleteByCodes(String codes) {
		return super.deleteByCodes(codes);
	}

}