package itez.plat.base.service.impl;

import itez.core.runtime.service.common.IComp;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;
import itez.plat.wrapper.service.ETreeService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DeptServiceImpl extends ETreeService<Dept> implements DeptService {

	@Override
	@Cache.able(cache="DEPT_BY_ID", key="#(id)")
	public Dept findById(String id) {
		return super.findById(id);
	}
	
	/**
	 * 返回tmid对应的机构
	 * @param tmid
	 * @return
	 */
	public Dept findByTmid(Object tmid) {
		Querys qs = Querys.and(Query.eq("tmid", tmid));
		return selectFirst(qs);
	}
	
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	public Dept createRootDept(){
		return createRootDept($comp());
	}
	
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	public Dept createRootDept(IComp comp){
		Dept dept = getRootDept(comp.getId());
		if(dept != null) return dept;
		dept = new Dept();
		dept.setCompId(comp.getId());
		dept.setCaption(comp.getCaption());
		dept.setSummary("默认部门");
		dept.setSort(1);
		dept.setPath(EStr.addPrefix(1, 3));
		dept.save();
		return dept;
	}
	
	@Cache.able(key="#(compId)")
	public Dept getRootDept(String compId){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.nu("pid"));
		return selectFirst(qs);
	}

	@Cache.able(cache="dept_all", key="#(compId)")
	public List<Dept> getAllDepts(String compId){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.nn("pid"));
		return select(qs, "path", null);
	}

	public List<Dept> getAllDepts(String compId, String pid){
		Dept dept = super.findById(pid);
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.like("path", dept.getPath() + "_%"));
		return select(qs, "path", null);
	}
	
	public List<Dept> getSubDepts(String compId, String pid){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.eq("pid", pid));
		return select(qs);
	}
	
	public List<Dept> getDepts(String compId, String ids){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	public List<Dept> getDepts(String compId, String ids, String orderby){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	@Cache.del(cache="dept_all", key="#(dept.compId)")
	public void addDept(Dept dept){
		if(EStr.isEmpty(dept.getCompId())) dept.setCompId($comp().getId());
		dept.save();
	}
	
	@Cache.del(cache="dept_all", key="#(dept.compId)")
	public void modifyDept(Dept dept){
		dept.update();
		ECacheKit.remove("DEPT_BY_ID", dept.getId());
	}
	
	@Cache.del(cache="dept_all", key="#(compId)")
	public void removeDepts(String compId, String ids){
		List<Dept> list = getDepts(compId, ids);
		list.forEach(dept -> {
			dept.disable();
			ECacheKit.remove("DEPT_BY_ID", dept.getId());
		});
	}
	
	public Dept getLastDept(String pid){
		return super.getLast(pid);
	}

	public void sort(String pid, String opt, String ids){
		super.sort(pid, opt, ids);
	}

}