package itez.plat.base.service;

import java.util.List;

import com.jfinal.aop.Invocation;

import itez.core.runtime.service.IModelService;
import itez.plat.base.model.Menu;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface MenuService extends IModelService<Menu>{

	/**
	 * 一次性返回平铺型菜单数据（用于后台菜单管理）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getMenuTree(String mtype);
	
	/**
	 * 一次性返回树型菜单数据（用于前台菜单展示）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype);
	
	/**
	 * 一次性返回树型菜单数据（指定父菜单，用于前台菜单展示）
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype, String pid);
	
	public Menu getLastMenu(String mtype, String pid);
	public void sort(String mtype, String pid, String opt, String ids);
	
	/**
	 * 菜单鉴权
	 * @param inv
	 * @param mtype
	 */
	public void interceptorMenu(Invocation inv, String mtype);

}