$(function () {
'use strict'
	//主题列表
	var mySkins = ['skin-blue', 'skin-red', 'skin-yellow', 'skin-green']
	//切换主题
	function changeSkin(cls) {
		$.each(mySkins, function (i) { $('body').removeClass(mySkins[i]) })
		$('body').addClass(cls)
		store.set('JW_SKIN', cls)
		return false
	}
	/**
	 * 页面初始化
	 */
	function setup() {
		//初始化页面主题
		var skin = store.get("JW_SKIN");
		if($.itez.kit.isEmpty(skin)) skin = "skin-blue";
		if (skin && $.inArray(skin, mySkins)) changeSkin(skin);
		//初始化菜单显示
		let sidebarCls = 'sidebar-collapse';
		let sidebar = store.get("JW_SIDEBAR");
		if(sidebar === 'open') $(document.body).removeClass(sidebarCls);
		//切换主题
		$("[data-skin]").on("click", function (e) { e.preventDefault(); changeSkin($(this).data("skin")); })
		//初始化iCheck
		$("input[type='checkbox']").iCheck({ checkboxClass : "icheckbox_square-blue", increaseArea : "20%" });
		$("input[type='radio']").iCheck({ radioClass : "iradio_square-blue", increaseArea : "20%" });
		//初始化操作提示框
		$('[data-toggle="tooltip"]').tooltip();
		//默认加载表单校验器
		$.itez.formValidator.bindFormVali();
		//使用select2插件
		$(".select2").select2();
		//使用slider插件
		$(".slider").slider({ id: 'blue', tooltip: 'always', tooltip_position:'bottom' });
		//折叠左侧菜单条时，内容区自适应
		$('.sidebar-toggle').on('click', function(){
			store.set("JW_SIDEBAR", $(document.body).hasClass(sidebarCls)? 'open' : 'close');
			setTimeout($.itez.charts.resize, 300);
		});
		//改变窗口大小时，内容区自适应
		$(window).on('resize', $.itez.charts.resize);
	}
	setup()
});
	  