/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.site.controller;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.wrapper.controller.EControllerMgr;
import java.util.List;

@ControllerDefine(key="/site/content", summary="\u7f51\u7ad9\u6587\u7ae0\u7ba1\u7406", view="/")
public class SiteContentController
extends EControllerMgr {
    @Inject
    ChannelService channelSer;
    @Inject
    ContentService contentSer;

    public void index() {
        Channel indexChannel = (Channel)this.channelSer.findByCode("Index");
        List<Channel> channels = this.channelSer.getTreeChannels();
        String pid = this.getPara("pid", indexChannel.getId());
        List<Content> contents = this.contentSer.getByChannelId(pid);
        this.setAttr("pid", pid);
        this.setAttr("indexChannel", (Object)indexChannel);
        this.setAttr("channels", channels);
        this.setAttr("contents", contents);
        this.render("content.html");
    }

    public void addContent() {
        UploadFile picFile = this.getFile("pic");
        String picUrl = picFile != null ? this.getUpload(picFile.getFile()) : "";
        String pid = this.getPara("pid");
        Content content = new Content();
        content.setChannelId(pid);
        content.setCaption(this.getPara("caption"));
        content.setSubCaption(this.getPara("subCaption"));
        content.setSummary(this.getPara("summary"));
        content.setAuthor(this.getPara("author"));
        content.setContent(this.getPara("content"));
        content.setSort(0);
        if (EStr.notEmpty((String)picUrl)) {
            content.setPic(picUrl);
        }
        this.contentSer.save(content);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void modifyContent() {
        UploadFile picFile = this.getFile("pic");
        String picUrl = picFile != null ? this.getUpload(picFile.getFile()) : "";
        String id = this.getPara("id");
        Content content = (Content)this.contentSer.findById(id);
        String pid = content.getChannelId();
        content.setCaption(this.getPara("caption"));
        content.setSubCaption(this.getPara("subCaption"));
        content.setSummary(this.getPara("summary"));
        content.setAuthor(this.getPara("author"));
        content.setContent(this.getPara("content"));
        content.setSort(0);
        if (EStr.notEmpty((String)picUrl)) {
            content.setPic(picUrl);
        }
        this.contentSer.update(content);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void removeContent() {
        String pid = this.getPara("pid");
        String ids = this.getPara("ids");
        this.contentSer.deleteByIds(ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }
}

