/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.site.controller;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;
import itez.plat.wrapper.controller.EControllerMgr;
import java.util.List;

@ControllerDefine(key="/site/channel", summary="\u7f51\u7ad9\u680f\u76ee\u7ba1\u7406", view="/")
public class SiteChannelController
extends EControllerMgr {
    @Inject
    ChannelService channelSer;

    public void index() {
        Channel indexChannel = this.channelSer.getIndexChannel();
        List<Channel> channels = this.channelSer.getAllChannels();
        this.setAttr("pid", this.getPara("pid", indexChannel.getId()));
        this.setAttr("indexChannel", (Object)indexChannel);
        this.setAttr("channels", channels);
        this.render("channel.html");
    }

    public void addChannel() {
        UploadFile picFile = this.getFile("pic");
        String picUrl = picFile != null ? this.getUpload(picFile.getFile()) : "";
        String pid = this.getPara("pid");
        Channel parent = (Channel)this.channelSer.findById(pid);
        Channel last = this.channelSer.getLastChannel(pid);
        Integer sort = last == null ? 1 : last.getSort() + 1;
        String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix((int)sort, (int)3));
        Channel channel = new Channel();
        channel.setPid(pid);
        channel.setPath(path);
        channel.setSort(sort);
        String code = this.getPara("code");
        String icon = this.getPara("icon");
        String caption = this.getPara("caption");
        String subCaption = this.getPara("subCaption");
        String content = this.getPara("content");
        String channelTemp = this.getPara("channelTemp");
        String contentTemp = this.getPara("contentTemp");
        channel.setCode(code);
        channel.setIcon(icon);
        channel.setPic(picUrl);
        channel.setCaption(caption);
        channel.setSubCaption(subCaption);
        channel.setContent(content);
        channel.setChannelTemp(channelTemp);
        channel.setContentTemp(contentTemp);
        this.channelSer.addChannel(channel);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void modifyChannel() {
        UploadFile picFile = this.getFile("pic");
        String picUrl = picFile != null ? this.getUpload(picFile.getFile()) : "";
        String id = this.getPara("id");
        Channel channel = (Channel)this.channelSer.findById(id);
        String pid = channel.getPid();
        String code = this.getPara("code");
        String icon = this.getPara("icon");
        String caption = this.getPara("caption");
        String subCaption = this.getPara("subCaption");
        String content = this.getPara("content");
        String channelTemp = this.getPara("channelTemp");
        String contentTemp = this.getPara("contentTemp");
        channel.setCode(code);
        channel.setIcon(icon);
        if (EStr.notEmpty((String)picUrl)) {
            channel.setPic(picUrl);
        }
        channel.setCaption(caption);
        channel.setSubCaption(subCaption);
        channel.setContent(content);
        channel.setChannelTemp(channelTemp);
        channel.setContentTemp(contentTemp);
        this.channelSer.modifyChannel(channel);
        this.redirect(this.attr().getCtrl() + "/?pid=" + pid);
    }

    public void removeChannel() {
        String pid = this.getPara("pid");
        String ids = this.getPara("ids");
        this.channelSer.removeChannels(ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void sortChannel() {
        String pid = this.getPara("pid");
        String opt = this.getPara("opt");
        String ids = this.getPara("ids");
        this.channelSer.sort(pid, opt, ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }
}

