/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.msg.service.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.plat.msg.model.Subject;
import itez.plat.msg.model.User;
import itez.plat.msg.service.MsgType;
import itez.plat.msg.service.ReciveService;
import itez.plat.msg.service.SubjectService;
import itez.plat.msg.service.UserService;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Define
@Singleton
public class UserServiceImpl
extends EModelService<User>
implements UserService {
    @Inject
    SubjectService subjectSer;
    @Inject
    ReciveService reciveSer;

    @Override
    public Integer getUnreadCount(String uid, String uname) {
        this.generSysMsg(uid, uname);
        return this.getUnreadCountRel(uid);
    }

    @Override
    public Page<Record> getUnreadList(String uid) {
        return this.getUnreadList(uid, null);
    }

    @Override
    public Page<Record> getUnreadList(String uid, MsgType mtype) {
        return this.getUnreadList(uid, mtype, 1);
    }

    @Override
    public Page<Record> getUnreadList(String uid, MsgType mtype, Integer pageNum) {
        Kv paras = Kv.by((Object)"uid", (Object)uid);
        if (mtype != null) {
            paras.set((Object)"mtype", (Object)mtype.getValue());
        }
        SqlPara sqlPara = this.dbo().getSqlPara("getUnreadList", (Map)paras);
        return this.dbo().paginate(pageNum.intValue(), 20, sqlPara);
    }

    @Override
    public void generSysMsg(String uid, String uname) {
        User user = this.getUserStatus(uid);
        Date lastSys = this.subjectSer.getLastSysMsg();
        if (lastSys == null) {
            return;
        }
        if (user.getLastDate().before(lastSys)) {
            return;
        }
        List<Subject> subjects = this.subjectSer.getNewSysMsg(user.getLastDate());
        if (subjects == null || subjects.size() == 0) {
            return;
        }
        for (Subject subject : subjects) {
            this.reciveSer.generSysMsg(subject.getId(), user.getUserId(), uname);
        }
        this.setUserStatus(user, subjects.size());
    }

    public Integer getUnreadCountRel(String uid) {
        return this.reciveSer.getUnreadCountRel(uid);
    }

    @Override
    public User getUserStatus(String uid) {
        Querys qs = Querys.and((Query)Query.eq((String)"userId", (Object)uid));
        User us = (User)this.selectFirst(qs);
        if (us == null) {
            us = (User)((Object)((User)((Object)new User().setUserId(uid))).setLastDate(EDate.getDate()));
            this.save(us);
        }
        return us;
    }

    @Override
    public void setUserStatus(User us, Integer unread) {
        us.setLastDate(EDate.getDate());
        this.update(us);
    }
}

