/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.plat.base.model.User;
import itez.plat.base.service.UserIOService;

@Define
@Singleton
public class UserIOServiceImpl
extends EModelService<User>
implements UserIOService {
    @Override
    public User addUser(User user, String loginPass) {
        user.setSalt(HashKit.generateSaltForSha512());
        user.setLoginPass(HashKit.md5((String)(loginPass + user.getSalt())));
        user.save();
        return user;
    }

    @Override
    public User modifyUser(User user) {
        user.update();
        ECacheKit.remove((String)"USER_BY_ID", (Object)user.getId());
        ECacheKit.remove((String)"USER_BY_LOGIN", (Object)String.format("%s.%s", user.getDomain(), user.getLoginName()));
        return user;
    }

    @Override
    public User modifyUser(User user, String loginPass) {
        user.setLoginPass(HashKit.md5((String)(loginPass + user.getSalt())));
        user.update();
        ECacheKit.remove((String)"USER_BY_ID", (Object)user.getId());
        ECacheKit.remove((String)"USER_BY_LOGIN", (Object)String.format("%s.%s", user.getDomain(), user.getLoginName()));
        return user;
    }

    @Override
    public void removeUser(User user) {
        user.disable();
        ECacheKit.remove((String)"USER_BY_ID", (Object)user.getId());
        ECacheKit.remove((String)"USER_BY_LOGIN", (Object)String.format("%s.%s", user.getDomain(), user.getLoginName()));
    }
}

