/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.google.inject.Singleton;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.common.IComp;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;
import itez.plat.wrapper.service.ETreeService;
import java.util.List;

@Define
@Singleton
public class DeptServiceImpl
extends ETreeService<Dept>
implements DeptService {
    @Cache.able(cache="DEPT_BY_ID", key="#(id)")
    public Dept findById(String id) {
        return (Dept)super.findById(id);
    }

    @Override
    public Dept findByTmid(Object tmid) {
        Querys qs = Querys.and((Query)Query.eq((String)"tmid", (Object)tmid));
        return (Dept)this.selectFirst(qs);
    }

    @Override
    public Dept createRootDept() {
        return this.createRootDept(this.$comp());
    }

    @Override
    public Dept createRootDept(IComp comp) {
        Dept dept = this.getRootDept(comp.getId());
        if (dept != null) {
            return dept;
        }
        dept = new Dept();
        dept.setCompId(comp.getId());
        dept.setCaption(comp.getCaption());
        dept.setSummary("\u9ed8\u8ba4\u90e8\u95e8");
        dept.setSort(1);
        dept.setPath(EStr.addPrefix((int)1, (int)3));
        dept.save();
        return dept;
    }

    @Override
    @Cache.able(key="#(compId)")
    public Dept getRootDept(String compId) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.nu((String)"pid"));
        return (Dept)this.selectFirst(qs);
    }

    @Override
    @Cache.able(cache="dept_all", key="#(compId)")
    public List<Dept> getAllDepts(String compId) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.nn((String)"pid"));
        return this.select(qs, "path", null);
    }

    @Override
    public List<Dept> getAllDepts(String compId, String pid) {
        Dept dept = (Dept)super.findById(pid);
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(dept.getPath() + "_%")));
        return this.select(qs, "path", null);
    }

    @Override
    public List<Dept> getSubDepts(String compId, String pid) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.eq((String)"pid", (Object)pid));
        return this.select(qs);
    }

    @Override
    public List<Dept> getDepts(String compId, String ids) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs);
    }

    @Override
    public List<Dept> getDepts(String compId, String ids, String orderby) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs, "sort " + orderby);
    }

    @Override
    @Cache.del(cache="dept_all", key="#(dept.compId)")
    public void addDept(Dept dept) {
        if (EStr.isEmpty((String)dept.getCompId())) {
            dept.setCompId(this.$comp().getId());
        }
        dept.save();
    }

    @Override
    @Cache.del(cache="dept_all", key="#(dept.compId)")
    public void modifyDept(Dept dept) {
        dept.update();
        ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
    }

    @Override
    @Cache.del(cache="dept_all", key="#(compId)")
    public void removeDepts(String compId, String ids) {
        List<Dept> list = this.getDepts(compId, ids);
        list.forEach(dept -> {
            dept.disable();
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
        });
    }

    @Override
    public Dept getLastDept(String pid) {
        return (Dept)((Object)super.getLast(pid));
    }

    @Override
    public void sort(String pid, String opt, String ids) {
        super.sort(pid, opt, ids);
    }
}

