/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.controller;

import com.google.inject.Inject;
import com.jfinal.kit.HashKit;
import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.model.User;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.RoleService;
import itez.plat.base.service.UserService;
import itez.plat.wrapper.controller.EControllerMgr;
import java.util.List;

@ControllerDefine(key="/insUser", summary="\u6210\u5458\u7ba1\u7406", view="/")
@AuthRequire.Logined
public class InsUserController
extends EControllerMgr {
    @Inject
    UserService us;
    @Inject
    DeptService ds;
    @Inject
    RoleService rs;

    public void index() {
        this.ds.createRootDept();
        User user = (User)this.session().getUser();
        String roleIds = user.getRoleIds();
        List roles = this.rs.findByIds(roleIds);
        String compId = this.attr().getComp().getId();
        Dept rootDept = this.ds.getRootDept(compId);
        String pid = this.getPara("pid", rootDept.getId());
        List<Dept> depts = this.ds.getAllDepts(compId);
        List<User> users = this.us.getInsUsers(this.attr().getDomain(), pid);
        this.setAttr("pid", pid);
        this.setAttr("rootDept", (Object)rootDept);
        this.setAttr("depts", depts);
        this.setAttr("users", users);
        this.setAttr("roles", roles);
        this.render("insUser.html");
    }

    public void add() {
        String pid = this.getPara("pid");
        String loginName = this.getPara("loginName");
        String loginPass = this.getPara("loginPass", loginName);
        User user = new User();
        user.setDomain(this.attr().getDomain());
        user.setMember(1);
        user.setCaption(this.getPara("caption"));
        user.setLoginName(loginName);
        user.setLevel(0);
        user.setRoleIds(EStr.parseArray((String[])this.getParaValues("roleIds")));
        user.setDeptId(pid);
        this.us.add(user, loginPass);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void modify() {
        String pid = this.getPara("pid");
        String id = this.getPara("id");
        User user = (User)this.us.findById(id);
        user.setCaption(this.getPara("caption"));
        user.setLoginName(this.getPara("loginName"));
        user.setRoleIds(EStr.parseArray((String[])this.getParaValues("roleIds")));
        String loginPass = this.getPara("loginPass");
        if (EStr.notEmpty((String)loginPass)) {
            user.setLoginPass(HashKit.md5((String)(loginPass + user.getSalt())));
        }
        this.us.modify(user);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void remove() {
        String pid = this.getPara("pid");
        String ids = this.getPara("ids");
        this.us.remove(this.attr().getDomain(), ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }
}

