/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.beust.jcommander.internal.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.EWeb;
import itez.plat.base.model.CompBank;
import itez.plat.base.model.CompWx;
import itez.plat.base.service.CompBankService;
import itez.plat.base.service.CompWxService;
import itez.plat.base.service.WxService;
import itez.weixin.api.PaymentApi;
import itez.weixin.kit.PaymentKit;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

@Define
@Singleton
public class WxServiceImpl
extends EService
implements WxService {
    @Inject
    CompWxService cwxs;
    @Inject
    CompBankService cbs;

    @Override
    public ERet payFor(String appId, String openId, PaymentApi.TradeType tradeType, String productId, String orderId, String body, BigDecimal fee, String callBackUrl) throws Exception {
        CompWx comp = this.cwxs.findByAppId(appId);
        if (comp == null) {
            throw new Exception("\u5355\u4f4d\u7684appId\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff01");
        }
        CompBank bank = this.cbs.findBankConfig();
        if (bank == null) {
            throw new Exception("\u8fd8\u672a\u8bbe\u7f6e\u5546\u6237\u4fe1\u606f\uff01");
        }
        String businessId = bank.getBusinessId();
        String businessKey = bank.getBusinessKey();
        String ip = EWeb.getIpAddr((HttpServletRequest)EContext.getRequest());
        if (EStr.isEmpty((String)ip)) {
            ip = "127.0.0.1";
        }
        int totao_fee = fee.multiply(new BigDecimal("100")).intValue();
        Map params = Maps.newHashMap();
        params.put("appid", appId);
        params.put("mch_id", businessId);
        params.put("body", body);
        if (tradeType == PaymentApi.TradeType.NATIVE) {
            params.put("product_id", productId);
        }
        if (tradeType == PaymentApi.TradeType.JSAPI) {
            params.put("openid", openId);
        }
        params.put("out_trade_no", orderId);
        params.put("total_fee", totao_fee + "");
        params.put("spbill_create_ip", ip);
        params.put("trade_type", tradeType.name());
        params.put("nonce_str", System.currentTimeMillis() / 1000L + "");
        params.put("notify_url", callBackUrl);
        String sign = PaymentKit.createSign((Map)params, (String)businessKey);
        params.put("sign", sign);
        String xmlResult = PaymentApi.pushOrder((Map)params);
        Map result = PaymentKit.xmlToMap((String)xmlResult);
        String return_code = (String)result.get("return_code");
        String return_msg = (String)result.get("return_msg");
        if (EStr.isEmpty((String)return_code) || !"SUCCESS".equals(return_code)) {
            throw new Exception(return_msg);
        }
        String result_code = (String)result.get("result_code");
        String err_code_des = (String)result.get("err_code_des");
        if (EStr.isEmpty((String)result_code) || !"SUCCESS".equals(result_code)) {
            throw new Exception(err_code_des);
        }
        String prepayId = (String)result.get("prepay_id");
        String codeUrl = (String)result.get("code_url");
        ERet ret = ERet.create();
        ret.set((Object)"codeUrl", (Object)codeUrl);
        if (tradeType == PaymentApi.TradeType.JSAPI) {
            String timestamp = System.currentTimeMillis() / 1000L + "";
            String nonceStr = this.$UUID();
            String packageStr = "prepay_id=" + prepayId;
            String signType = "MD5";
            TreeMap<String, String> wxMap = new TreeMap<String, String>();
            wxMap.put("appId", appId);
            wxMap.put("timeStamp", timestamp);
            wxMap.put("nonceStr", nonceStr);
            wxMap.put("package", packageStr);
            wxMap.put("signType", signType);
            String paySign = PaymentKit.createSign(wxMap, (String)businessKey);
            ret.set((Object)"timestamp", (Object)timestamp);
            ret.set((Object)"nonceStr", (Object)nonceStr);
            ret.set((Object)"package", (Object)packageStr);
            ret.set((Object)"signType", (Object)signType);
            ret.set((Object)"paySign", (Object)paySign);
        }
        return ret;
    }
}

