/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.queue;

import com.google.inject.Singleton;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.core.runtime.service.queue.IQueueService;
import itez.core.runtime.service.queue.QueueHandleService;
import itez.core.runtime.session.ERequestBean;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

@Define
@Singleton
public class QueueProcessService
extends EService
implements IQueueService {
    private final ELogBase log = ELog.log(((Object)((Object)this)).getClass());
    private final ExecutorService customerPool;
    private final BlockingQueue<ERequestBean> queue;
    private final Boolean queueUsed = EProp.QueueUsed;
    private final Integer maxQueueSize = EProp.QueueMaxSize;
    private final Integer threadPoolSize = EProp.QueueCustomerThreadSize;
    private Boolean threadPoolInit = false;
    private Boolean customerRunningFlag = false;
    private Boolean producerRunningFlag = false;

    public QueueProcessService() {
        if (this.queueUsed.booleanValue()) {
            this.queue = new LinkedBlockingQueue<ERequestBean>(this.maxQueueSize);
            this.customerPool = Executors.newFixedThreadPool(this.threadPoolSize);
            this.log.info("\u5df2\u521b\u5efa\u961f\u5217\uff0c\u6700\u5927\u6570\u91cf\uff1a{}", new Object[]{this.maxQueueSize});
            this.log.info("\u5df2\u521b\u5efa\u6d88\u8d39\u8005\u7ebf\u7a0b\u6c60\uff0c\u6700\u5927\u6570\u91cf\uff1a{}", new Object[]{this.threadPoolSize});
        } else {
            this.queue = null;
            this.customerPool = null;
        }
    }

    private void initThreadPool() {
        this.threadPoolInit = true;
        for (int i = 0; i < this.threadPoolSize; ++i) {
            QueueHandleService handle = new QueueHandleService();
            this.customerPool.execute((Runnable)handle);
        }
        this.customerPool.shutdown();
    }

    public void offer(ERequestBean data) throws Exception {
        if (this.queue == null) {
            throw new Exception("\u8fd8\u672a\u521b\u5efa\u961f\u5217");
        }
        if (this.queue.size() >= this.maxQueueSize) {
            throw new Exception("\u961f\u5217\u5df2\u6ee1");
        }
        if (this.queue.offer(data)) {
            this.producerRunningFlag = true;
            if (!this.threadPoolInit.booleanValue()) {
                this.initThreadPool();
            }
        } else {
            throw new Exception("\u63d2\u5165\u961f\u5217\u5931\u8d25");
        }
    }

    public void stopProduce() {
        this.producerRunningFlag = false;
        this.customerPool.shutdown();
    }

    public Boolean getQueueUsed() {
        return this.queueUsed;
    }

    public int getQueueSize() {
        return this.queue == null ? 0 : this.queue.size();
    }

    public BlockingQueue<ERequestBean> getQueue() {
        return this.queue;
    }

    public Boolean getCustomerRunningFlag() {
        return this.customerRunningFlag;
    }

    public void setCustomerRunningFlag(Boolean customerRunningFlag) {
        this.customerRunningFlag = customerRunningFlag;
    }

    public Boolean getProducerRunningFlag() {
        return this.producerRunningFlag;
    }

    public void setProducerRunningFlag(Boolean producerRunningFlag) {
        this.producerRunningFlag = producerRunningFlag;
    }
}

