package itez.plat.source.plugins.rdb.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.jfinal.plugin.activerecord.ActiveRecordPlugin;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.plugin.EActiveRecordPlugin;
import itez.core.wrapper.dbo.plugin.EDruidPlugin;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.cache.ECacheFactory;
import itez.plat.source.model.DataBase;

//@Define(SourceConfig.SERVICE_SOURCE_DATA_BASE)
public class DataBaseService extends EModelService<DataBase> {

	private final static Map<String, EDruidPlugin> druids = new ConcurrentHashMap<>();
	private final static Map<String, ActiveRecordPlugin> arps = new ConcurrentHashMap<>();
	
	public DataBase getDataBase(String id){
		return findById(id);
	}
	
	public List<DataBase> getDataBases(String ids){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	public DataBase getDataBaseByCode(String code){
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.eq("used", 1));
		DataBase db = selectFirst(qs);
		db.put("isStarted", getDataBaseStatus(db.getCode()));
		return db;
	}

	public List<DataBase> getAllDataBase(){
		Querys qs = Querys.and(Query.eq("used", 1));
		List<DataBase> dbs = select(qs, null, null, "id, code, caption, summary, dbType, dbDriverClass, dbUrl, dbUserName, dbInitialSize, dbMinIdle, dbMaxActive, autoRun, allowCreateTable, accessLevel");
		dbs.forEach(db -> {
			db.put("isStarted", getDataBaseStatus(db.getCode()));
		});
		return dbs;
	}
	
	public Boolean getDataBaseStatus(String code){
		if(druids.containsKey(code)){
			return druids.get(code).isStarted();
		}
		return false;
	}
	
	public boolean startDataBase(String code){
		if(druids.containsKey(code)){
			EDruidPlugin druid = druids.get(code);
			if(druid.isStarted()) return true;
			druid.start();
			
			EActiveRecordPlugin arp = new EActiveRecordPlugin(code, druid.getDataSource());
			arp.setCache(ECacheFactory.me.getCache());
			arp.setDialect(EDialect.parseDialect(druid.getDbType()));
			arp.start();
			arps.put(code, arp);
			return true;
		}else{
			DataBase db = getDataBaseByCode(code);
			DbProp prop = new DbProp();
			prop.setConnName(code);
			prop.setType(EDialect.DbType.fromString(db.getDbType()));
			prop.setDriverClass(db.getDbDriverClass());
			prop.setJdbcUrl(db.getDbUrl());
			prop.setUserName(db.getDbUserName());
			prop.setPassWord(db.getDbPassWord());
			prop.setInitialSize(db.getDbInitialSize());
			prop.setMinIdle(db.getDbMinIdle());
			prop.setMaxActive(db.getDbMaxActive());
			
			EDruidPlugin druid = new EDruidPlugin(prop, true);
			boolean start = druid.start();
			if(!start) return false;
			
			EActiveRecordPlugin arp = new EActiveRecordPlugin(code, druid.getDataSource());
			arp.setCache(ECacheFactory.me.getCache());
			arp.setDialect(EDialect.parseDialect(druid.getDbType()));
			start = arp.start();
			if(!start){
				druid.stop();
				return false;
			}
			druids.put(code, druid);
			arps.put(code, arp);
			return true;
		}
	}
	
	public void stopDataBase(String code){
		if(!druids.get(code).isStarted()) return;
		arps.get(code).stop();
		druids.get(code).stop();
	}
	
	public void startAllDataBase(){
		List<DataBase> dbs = getAllDataBase();
		dbs.forEach(db -> {
			startDataBase(db.getCode());
		});
	}
	
	public void stopAllDataBase(){
		List<DataBase> dbs = getAllDataBase();
		dbs.forEach(db -> {
			stopDataBase(db.getCode());
		});
	}
	
	@Override
	public boolean update(DataBase model) {
		boolean run = false;
		String code = model.getCode();
		if(getDataBaseStatus(code)){
			run = true;
			stopDataBase(code);
			druids.remove(code);
			arps.remove(code);
		}
		boolean ret = super.update(model);
		if(ret && run) ret = startDataBase(code);
		return ret;
	}
	
	public List<ERet> getDbTypeList(){
		List<ERet> list = new ArrayList<>();
		list.add(ERet.create("value", EDialect.DbType.mysql.name()).set("text", "MySQL"));
		list.add(ERet.create("value", EDialect.DbType.postgresql.name()).set("text", "PostgreSQL"));
		list.add(ERet.create("value", EDialect.DbType.oracle.name()).set("text", "Oracle"));
		list.add(ERet.create("value", EDialect.DbType.sqlserver.name()).set("text", "SqlServer"));
		return list;
	}
	
	public void remove(String ids){
		List<DataBase> list = getDataBases(ids);
		list.forEach(item -> {
			String code = item.getCode();
			if(getDataBaseStatus(code)){
				stopDataBase(code);
				druids.remove(code);
				arps.remove(code);
			}
			item.disable();
		});
	}
	
}
