package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.site.SiteConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ChannelServiceImpl extends EModelService<Channel> implements ChannelService {

	public Channel createIndexChannel(){
		Channel channel = new Channel();
		channel.setCode(SiteConfig.INDEX_CODE);
		channel.setIcon("fa fa-home");
		channel.setPic("");
		channel.setCaption("网站首页");
		channel.setContent("");
		channel.setPath("001");
		channel.setSort(1);
		channel.setChannelTemp("index.html");
		channel.setContentTemp("content.html");
		super.save(channel);
		return channel;
	}
	
	public Channel getIndexChannel(){
		Channel channel = super.findByCode(SiteConfig.INDEX_CODE);
		if(channel == null) channel = createIndexChannel();
		return channel;
	}
	
	public List<Channel> getAllChannels(){
		Querys qs = Querys.and(Query.nn("pid"));
		return select(qs, "path", null);
	}
	
	public List<Channel> getTreeChannels(){
		Querys qs = Querys.and(Query.nn("pid"));
		Selector selector = Selector.select("id, pid, code, icon, pic, caption, subCaption, path").where(qs).orderBy("path");
		return select(selector);
	}

	public Channel getLastChannel(String pid){
		Querys qs = Querys.and(Query.eq("pid", pid));
		return selectFirst(qs, "sort desc");
	}
	
	public void addChannel(Channel channel){
		super.save(channel);
	}
	
	public void modifyChannel(Channel channel){
		super.update(channel);
	}
	
	public void removeChannels(String ids){
		super.deleteByIds(ids);
	}
	
	public Channel getPervChannel(String pid, Integer sort){
		Querys qs = Querys.and(Query.eq("pid", pid)).add(Query.lt("sort", sort));
		return selectFirst(qs, "sort desc");
	}
	
	public Channel getNextChannel(String pid, Integer sort){
		Querys qs = Querys.and(Query.eq("pid", pid)).add(Query.gt("sort", sort));
		return selectFirst(qs, "sort");
	}

	public List<Channel> getChannels(String ids, String orderby){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	public void sort(String pid, String opt, String ids){
		List<Channel> list = getChannels(ids, opt.equals("up") ? "asc" : "desc");
		if(opt.equals("up")){
			Channel perv = getPervChannel(pid, list.get(0).getSort());
			if(perv == null) return;
		}else{
			Channel next = getNextChannel(pid, list.get(0).getSort());
			if(next == null) return;
		}
		list.forEach(current -> {
			sort(pid, opt, current);
		});
	}
	
	public void sort(String pid, String opt, Channel current){
		if(opt.equals("up")){
			Channel perv = getPervChannel(pid, current.getSort());
			Integer pervSort = perv.getSort();
			String pervPath = perv.getPath();
			Integer currentSort = current.getSort();
			String currentPath = current.getPath();
			current.setSort(pervSort);
			current.setPath(pervPath);
			perv.setSort(currentSort);
			perv.setPath(currentPath);
			current.update();
			perv.update();
			
			Querys qsPerv = Querys.and(Query.like("path", pervPath + "_%"));
			Querys qsCurrent = Querys.and(Query.like("path", currentPath + "_%"));
			List<Channel> listPerv = select(qsPerv);
			listPerv.forEach(d -> {
				d.setPath(d.getPath().replace(pervPath, currentPath));
			});
			List<Channel> listCurrent = select(qsCurrent);
			listCurrent.forEach(d -> {
				d.setPath(d.getPath().replace(currentPath, pervPath));
			});
			dbo().batchUpdate(listPerv, 100);
			dbo().batchUpdate(listCurrent, 100);
		}else{
			Channel next = getNextChannel(pid, current.getSort());
			Integer nextSort = next.getSort();
			String nextPath = next.getPath();
			Integer currentSort = current.getSort();
			String currentPath = current.getPath();
			current.setSort(nextSort);
			current.setPath(nextPath);
			next.setSort(currentSort);
			next.setPath(currentPath);
			current.update();
			next.update();
			
			Querys qsNext = Querys.and(Query.like("path", nextPath + "_%"));
			Querys qsCurrent = Querys.and(Query.like("path", currentPath + "_%"));
			List<Channel> listNext = select(qsNext);
			listNext.forEach(d -> {
				d.setPath(d.getPath().replace(nextPath, currentPath));
			});
			List<Channel> listCurrent = select(qsCurrent);
			listCurrent.forEach(d -> {
				d.setPath(d.getPath().replace(currentPath, nextPath));
			});
			dbo().batchUpdate(listNext, 1000);
			dbo().batchUpdate(listCurrent, 1000);
		}
	}
	
	public List<Channel> getChildren(String id){
		Querys qs = Querys.and(Query.eq("pid", id));
		return select(qs, "sort", null);
	}
	
	public List<String> getChildrenIds(String id){
		Channel parent = findById(id);
		Querys qs = Querys.and(Query.like("path", parent.getPath() + "%"));
		return selectCol(qs, "id");
	}
	
}