package itez.plat.site.model;

import java.util.List;

import itez.core.runtime.service.ServiceManager;
import itez.kit.EStr;
import itez.plat.site.model.base.BaseNavi;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.NaviItemService;
import itez.plat.site.service.NaviService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Navi extends BaseNavi<Navi> {
	
	private final static ChannelService channelSer = ServiceManager.me.getService(ChannelService.class);
	private final static NaviService naviSer = ServiceManager.me.getService(NaviService.class);
	private final static NaviItemService naviItemSer = ServiceManager.me.getService(NaviItemService.class);
	
	public List<NaviItem> by(String code){
		Navi navi = naviSer.findByCode(code);
		List<NaviItem> items = naviItemSer.getByNaviId(navi.getId());
		for(NaviItem item : items){
			if(EStr.notEmpty(item.getChannelId()) && !item.getChannelId().equals("-")){
				Channel channel = channelSer.findById(item.getChannelId());
				if(channel != null){
					item.setCaption(channel.getCaption());
					item.setHref(channel.url());
				}
			}
		}
		return items;
	}
	
}
