package itez.plat.site.model;

import itez.core.runtime.EContext;
import itez.core.runtime.service.ServiceManager;
import itez.kit.EStr;
import itez.plat.site.SiteConfig;
import itez.plat.site.model.base.BaseContent;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Content extends BaseContent<Content> {
	
	private final static ChannelService channelSer = ServiceManager.me.getService(ChannelService.class);
	private final static ContentService contentSer = ServiceManager.me.getService(ContentService.class);
	
	public String url(){
		if(EStr.isEmpty(getId())) return EContext.getAttr().getSrc();
		return String.format("%s/%s/%s", EContext.getAttr().getSrc(), SiteConfig.CONTENT_ACTION, getId());
	}
	
	public Content by(String id){
		return contentSer.findById(id);
	}
	
	public Content next(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.next(getChannelId(), getMdate());
	}
	
	public Content previous(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.previous(getChannelId(), getMdate());
	}
	
	public Channel channel(){
		if(EStr.isEmpty(getChannelId())) return null;
		return channelSer.findById(getChannelId());
	}
	
}
