package itez.plat.site.model;

import java.util.List;

import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.EContext;
import itez.core.runtime.service.ServiceManager;
import itez.plat.site.SiteConfig;
import itez.plat.site.model.base.BaseChannel;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Channel extends BaseChannel<Channel> {

	private final static ChannelService channelSer = ServiceManager.me.getService(ChannelService.class);
	private final static ContentService contentSer = ServiceManager.me.getService(ContentService.class);
	
	public String url(){
		String code = getCode();
		if(code.equals(SiteConfig.INDEX_CODE))
			return EContext.getAttr().getSrc();
		else
			return String.format("%s/%s/%s", EContext.getAttr().getSrc(), SiteConfig.CHANNEL_ACTION, getCode());
	}
	
	public Channel by(String code){
		return channelSer.findByCode(code);
	}
	
	public Channel index(){
		return channelSer.getIndexChannel();
	}
	
	public Channel parent(){
		String code = getCode();
		if(code.equals(SiteConfig.INDEX_CODE))
			return null;
		else
			return channelSer.findById(getPid());
	}
	
	public List<Channel> children(){
		return channelSer.getChildren(getId());
	}
	
	public Content first(){
		return contentSer.first(getId());
	}
	
	public Content last(){
		return contentSer.last(getId());
	}
	
	public List<Content> list(){
		return list(null, true, false);
	}
	
	public List<Content> list(Integer count){
		return list(count, true, false);
	}
	
	public List<Content> list(Integer count, Boolean desc){
		return list(count, desc, false);
	}
	
	public List<Content> list(Integer count, Boolean desc, Boolean children){
		if(children){
			List<String> ids = channelSer.getChildrenIds(getId());
			return contentSer.getByChannelIds(ids, count, desc);
		}else{
			return contentSer.getByChannelId(getId(), count, desc);
		}
	}
	
	public Page<Content> page(Integer pageNum, Integer pageSize, Boolean desc, Boolean children){
		if(children){
			List<String> ids = channelSer.getChildrenIds(getId());
			return contentSer.getPageByChannelIds(ids, pageNum, pageSize, desc);
		}else{
			return contentSer.getPageByChannelId(getId(), pageNum, pageSize, desc);
		}
	}
	
	public List<Content> search(String keyword, Boolean desc, Boolean children){
		if(children){
			List<String> ids = channelSer.getChildrenIds(getId());
			return contentSer.searchByChannelIds(ids, keyword, desc);
		}else{
			return contentSer.searchByChannelId(getId(), keyword, desc);
		}
	}
	
}
