package itez.plat.site.controller;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EControllerSite;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.site.model.Navi;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.SiteTempService;

@ControllerDefine(key = "/", summary = "网站", view = "/")
public class IndexController extends EControllerSite {

	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService channelSer;
	
	@Inject
	ContentService contentSer;
	
	@Inject
	SiteTempService tempSer;
	
	private final static String ERROR_TEXT_CH = "抱歉！当前网站还未设置相关模板，无法显示页面。<br><br>如果您是网站管理员，请登录网站后台进行网站模板初始化操作。";
	private final static String ERROR_TEXT_EN = "I'm sorry! No template has been set up on the current website, so the page can not be displayed.<br><br>If you are a webmaster, please go to the back of the website to initialize the website template.";
	
	public void index(){
		Info site = infoSer.getInfo();
		Channel channel = channelSer.getIndexChannel();
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(view)){
			renderHtml(ERROR_TEXT_CH + "<br><br><hr><br>" + ERROR_TEXT_EN);
			return;
		}
		setAttr("site", site);
		setAttr("channel", channel);
		setAttr("content", new Content());
		setAttr("navi", new Navi());
		setAttr("request", getParaData());
		render(view);
		//redirect(attr().getIndexUrl());
	}
	
	public void channel(){
		String code = getPara(0);
		Info site = infoSer.getInfo();
		Channel channel = channelSer.findByCode(code);
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(view)){
			renderHtml(ERROR_TEXT_CH + "<br><br><hr><br>" + ERROR_TEXT_EN);
			return;
		}
		setAttr("site", site);
		setAttr("channel", channel);
		setAttr("content", new Content());
		setAttr("navi", new Navi());
		setAttr("request", getParaData());
		render(view);
	}
	
	public void content(){
		String id = getPara(0);
		Info site = infoSer.getInfo();
		Content content = contentSer.findById(id);
		Channel channel = channelSer.findById(content.getChannelId());
		String view = channel.getContentTemp();
		if(!tempSer.checkTemp(view)){
			renderHtml(ERROR_TEXT_CH + "<br><br><hr><br>" + ERROR_TEXT_EN);
			return;
		}
		setAttr("site", site);
		setAttr("channel", channel);
		setAttr("content", content);
		setAttr("navi", new Navi());
		setAttr("request", getParaData());
		render(view);
	}
	
}
