package itez.plat.msg.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.service.Define;
import itez.plat.msg.model.Subject;
import itez.plat.msg.service.MsgType;
import itez.plat.msg.service.SubjectService;

import java.util.Date;
import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */

/**
 * 
 * @author netwild
 *
 * type :
 * 
 * 		10 : 私信
 * 		20 : 系统
 *  		21 : 通知公告
 *  		22 : 待办提醒
 *		30 : 动态
 *			31 : 回复我
 *			32 : at我
 *			33 : 赞我
 *
 */
@Define
@Singleton
public class SubjectServiceImpl extends EModelService<Subject> implements SubjectService {

	@Override
	public Subject findById(String id) {
		return super.findById(id);
	}
	
	public Date getLastSysMsg(){
		Querys qs = Querys.and(Query.eq("mtype", MsgType.NOTICE.getValue()));
		Subject subject = super.selectFirst(qs, "cdate desc");
		return subject == null ? null : subject.getCdate();
	}
	
	public List<Subject> getNewSysMsg(Date fromDt){
		Querys qs = Querys.and(Query.eq("mtype", MsgType.NOTICE.getValue())).add(Query.ge("cdate", fromDt));
		return select(qs, "cdate desc");
	}
	
}