package itez.plat.msg.controller;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.msg.service.MsgType;
import itez.plat.msg.service.UserService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/", summary = "站内消息", view = "/")
public class IndexController extends EControllerMgr {

	@Inject
	UserService userSer;
	
	public void index(){
		Page<Record> unreadList = userSer.getUnreadList(session().getUid());
		setAttr("msgTypeGroupList", MsgType.groupList);
		setAttr("unreadList", unreadList);
		renderText("消息中心，未完成。。。");
	}
	
}
