package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Menu;
import itez.plat.base.service.MenuService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class MenuServiceImpl extends EModelService<Menu> implements MenuService {

	@Cache.able(key="#(compId)")
	public List<Menu> getCompMenus(String compId){
		return getCompMenus(compId, null);
	}

	public List<Menu> getCompMenus(String compId, String pid){
		Querys qs = Querys.and(Query.eq("compId", compId));
		qs.add(pid == null ? Query.nu("pid") : Query.eq("pid", pid));
		List<Menu> menus = select(Selector.select().where(qs));
		menus.forEach(menu -> {
			if(menu.getFolder() == 1){
				List<Menu> subs = getCompMenus(compId, menu.getId());
				if(null != subs && subs.size() > 0){
					menu.put("subs", subs);
				}
			}
		});
		return menus;
	}

}