package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IComp;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DeptServiceImpl extends EModelService<Dept> implements DeptService {

	@Override
	@Cache.able(cache="DEPT_BY_ID", key="#(id)")
	public Dept findById(String id) {
		return super.findById(id);
	}
	
	/**
	 * 返回tmid对应的机构
	 * @param tmid
	 * @return
	 */
	public Dept findByTmid(Object tmid) {
		Querys qs = Querys.and(Query.eq("tmid", tmid));
		return selectFirst(qs);
	}
	
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	public Dept createRootDept(){
		return createRootDept($comp());
	}
	
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	public Dept createRootDept(IComp comp){
		Dept dept = getRootDept(comp.getId());
		if(dept != null) return dept;
		dept = new Dept();
		dept.setCompId(comp.getId());
		dept.setCaption(comp.getCaption());
		dept.setSummary("默认部门");
		dept.setSort(1);
		dept.setPath(EStr.addPrefix(1, 3));
		dept.save();
		return dept;
	}
	
	@Cache.able(key="#(compId)")
	public Dept getRootDept(String compId){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.nu("pid"));
		return selectFirst(qs);
	}

	@Cache.able(cache="dept_all", key="#(compId)")
	public List<Dept> getAllDepts(String compId){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.nn("pid"));
		return select(qs, "path", null);
	}

	public List<Dept> getAllDepts(String compId, String pid){
		Dept dept = super.findById(pid);
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.like("path", dept.getPath() + "_%"));
		return select(qs, "path", null);
	}
	
	public List<Dept> getSubDepts(String compId, String pid){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.eq("pid", pid));
		return select(qs);
	}
	
	public List<Dept> getDepts(String compId, String ids){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	public List<Dept> getDepts(String compId, String ids, String orderby){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	public Dept getLastDept(String pid){
		return getLastDept($comp().getId(), pid);
	}
	
	public Dept getLastDept(String compId, String pid){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.eq("pid", pid));
		return selectFirst(qs, "sort desc");
	}
	
	@Cache.del(cache="dept_all", key="#(dept.compId)")
	public void addDept(Dept dept){
		if(EStr.isEmpty(dept.getCompId())) dept.setCompId($comp().getId());
		dept.save();
	}
	
	@Cache.del(cache="dept_all", key="#(dept.compId)")
	public void modifyDept(Dept dept){
		dept.update();
		ECacheKit.remove("DEPT_BY_ID", dept.getId());
	}
	
	@Cache.del(cache="dept_all", key="#(compId)")
	public void removeDepts(String compId, String ids){
		List<Dept> list = getDepts(compId, ids);
		list.forEach(dept -> {
			dept.disable();
			ECacheKit.remove("DEPT_BY_ID", dept.getId());
		});
	}
	
	public Dept getPervDept(String compId, String pid, Integer sort){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.eq("pid", pid)).add(Query.lt("sort", sort));
		return selectFirst(qs, "sort desc");
	}
	
	public Dept getNextDept(String compId, String pid, Integer sort){
		Querys qs = Querys.and(Query.eq("compId", compId)).add(Query.eq("pid", pid)).add(Query.gt("sort", sort));
		return selectFirst(qs, "sort");
	}
	
	@Cache.del(cache="dept_all", key="#(compId)")
	public void sort(String compId, String pid, String opt, String ids){
		List<Dept> list = getDepts(compId, ids, opt.equals("up") ? "asc" : "desc");
		if(opt.equals("up")){
			Dept pervDept = getPervDept(compId, pid, list.get(0).getSort());
			if(pervDept == null) return;
		}else{
			Dept nextDept = getNextDept(compId, pid, list.get(0).getSort());
			if(nextDept == null) return;
		}
		list.forEach(dept -> {
			sort(compId, pid, opt, dept);
		});
	}
	
	public void sort(String compId, String pid, String opt, Dept dept){
		if(opt.equals("up")){
			Dept pervDept = getPervDept(compId, pid, dept.getSort());
			Integer pervSort = pervDept.getSort();
			String pervPath = pervDept.getPath();
			Integer deptSort = dept.getSort();
			String deptPath = dept.getPath();
			dept.setSort(pervSort);
			dept.setPath(pervPath);
			pervDept.setSort(deptSort);
			pervDept.setPath(deptPath);
			dept.update();
			pervDept.update();
			ECacheKit.remove("DEPT_BY_ID", dept.getId());
			ECacheKit.remove("DEPT_BY_ID", pervDept.getId());
			
			Querys qsPerv = Querys.and(Query.eq("compId", compId)).add(Query.like("path", pervPath + "_%"));
			Querys qsDept = Querys.and(Query.eq("compId", compId)).add(Query.like("path", deptPath + "_%"));
			List<Dept> listPerv = select(qsPerv);
			listPerv.forEach(d -> {
				d.setPath(d.getPath().replace(pervPath, deptPath));
				ECacheKit.remove("DEPT_BY_ID", d.getId());
			});
			List<Dept> listDept = select(qsDept);
			listDept.forEach(d -> {
				d.setPath(d.getPath().replace(deptPath, pervPath));
				ECacheKit.remove("DEPT_BY_ID", d.getId());
			});
			dbo().batchUpdate(listPerv, 100);
			dbo().batchUpdate(listDept, 100);
		}else{
			Dept nextDept = getNextDept(compId, pid, dept.getSort());
			Integer nextSort = nextDept.getSort();
			String nextPath = nextDept.getPath();
			Integer deptSort = dept.getSort();
			String deptPath = dept.getPath();
			dept.setSort(nextSort);
			dept.setPath(nextPath);
			nextDept.setSort(deptSort);
			nextDept.setPath(deptPath);
			dept.update();
			nextDept.update();
			ECacheKit.remove("DEPT_BY_ID", dept.getId());
			ECacheKit.remove("DEPT_BY_ID", nextDept.getId());
			
			Querys qsNext = Querys.and(Query.eq("compId", compId)).add(Query.like("path", nextPath + "_%"));
			Querys qsDept = Querys.and(Query.eq("compId", compId)).add(Query.like("path", deptPath + "_%"));
			List<Dept> listNext = select(qsNext);
			listNext.forEach(d -> {
				d.setPath(d.getPath().replace(nextPath, deptPath));
				ECacheKit.remove("DEPT_BY_ID", d.getId());
			});
			List<Dept> listDept = select(qsDept);
			listDept.forEach(d -> {
				d.setPath(d.getPath().replace(deptPath, nextPath));
				ECacheKit.remove("DEPT_BY_ID", d.getId());
			});
			dbo().batchUpdate(listNext, 1000);
			dbo().batchUpdate(listDept, 1000);
		}
	}

}