/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.source.controller;

import com.jfinal.plugin.activerecord.Model;
import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.service.ServiceInjection;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.User;
import itez.plat.base.model.Vert;
import itez.plat.source.model.DataBase;
import itez.plat.source.plugins.SourceService;
import itez.plat.source.plugins.rdb.database.DataBaseService;
import java.util.Arrays;
import java.util.List;

@ControllerDefine(key="/database", summary="\u4e1a\u52a1\u6570\u636e\u5e93", view="/rdb")
@AuthRequire.Logined
public class DataBaseController
extends EController {
    @ServiceInjection(value="sourceService")
    SourceService dss;
    @ServiceInjection(value="sourceDataBaseService")
    DataBaseService dbs;

    public void index() {
        List<DataBase> list = this.dbs.getAllDataBase();
        this.setAttr("dbTypeList", this.dbs.getDbTypeList());
        this.setAttr("accessList", this.dss.getAccessList());
        this.setAttr("dataBases", list);
        this.render("dataBase.html");
    }

    public void start() {
        String ids = this.getPara("ids");
        if (EStr.notEmpty((String)ids)) {
            String[] arr = ids.split(",");
            Arrays.stream(arr).forEach(id -> {
                DataBase db = this.dbs.getDataBase((String)id);
                this.dbs.startDataBase(db.getCode());
            });
        }
        this.redirect(this.attr().getCtrl());
    }

    public void stop() {
        String ids = this.getPara("ids");
        if (EStr.notEmpty((String)ids)) {
            String[] arr = ids.split(",");
            Arrays.stream(arr).forEach(id -> {
                DataBase db = this.dbs.getDataBase((String)id);
                this.dbs.stopDataBase(db.getCode());
            });
        }
        this.redirect(this.attr().getCtrl());
    }

    public void add() {
        User user = (User)this.session().getUser();
        DataBase obj = (DataBase)((Object)this.getBean(DataBase.class, ""));
        if (obj.getCode().equals("main")) {
            this.setFlashMsg("\u6570\u636e\u5e93\u522b\u540d\u4e0d\u5141\u8bb8\u4f7f\u7528\u201cmain\u201d\uff0c\u8bf7\u4fee\u6539\uff01");
            this.redirect(this.attr().getCtrl());
            return;
        }
        DataBase objExist = this.dbs.getDataBaseByCode(obj.getCode());
        if (objExist != null) {
            this.setFlashMsg("\u6570\u636e\u5e93\u522b\u540d[" + obj.getCode() + "]\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff01");
            this.redirect(this.attr().getCtrl());
            return;
        }
        Vert vert = user.getVert();
        obj.setOwnerCompId(this.attr().getComp().getId());
        obj.setOwnerCompName(this.attr().getComp().getCaption());
        obj.setOwnerDeptId(user.getDeptId());
        obj.setOwnerDeptName(user.getDept().getCaption());
        obj.setOwnerVertId(vert == null ? null : vert.getId());
        obj.setOwnerVertName(vert == null ? null : vert.getCaption());
        obj.setOwnerUserId(user.getId());
        obj.setOwnerUserName(user.getCaption());
        this.dbs.save(obj);
        this.redirect(this.attr().getCtrl());
    }

    public void modify() {
        DataBase obj = (DataBase)((Object)this.getBean(DataBase.class, ""));
        if (EStr.isEmpty((String)obj.getDbPassWord())) {
            obj.keep(new String[]{"id", "code", "caption", "summary", "dbType", "dbDriverClass", "dbUrl", "dbUserName", "dbInitialSize", "dbMinIdle", "dbMaxActive", "autoRun", "allowCreateTable", "accessLevel"});
        }
        DataBase objOld = (DataBase)this.dbs.findById(obj.getId());
        objOld._setAttrs((Model)obj);
        this.dbs.update(objOld);
        this.redirect(this.attr().getCtrl());
    }

    public void remove() {
        String ids = this.getPara("ids");
        this.dbs.remove(ids);
        this.redirect(this.attr().getCtrl());
    }
}

