/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.site.service.impl;

import com.google.inject.Singleton;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;
import java.util.List;

@Define
@Singleton
public class ChannelServiceImpl
extends EModelService<Channel>
implements ChannelService {
    @Override
    public Channel createIndexChannel() {
        Channel channel = new Channel();
        channel.setCode("Index");
        channel.setIcon("fa fa-home");
        channel.setPic("");
        channel.setCaption("\u7f51\u7ad9\u9996\u9875");
        channel.setContent("");
        channel.setPath("001");
        channel.setSort(1);
        channel.setChannelTemp("index.html");
        channel.setContentTemp("content.html");
        super.save((EModel)channel);
        return channel;
    }

    @Override
    public Channel getIndexChannel() {
        Channel channel = (Channel)super.findByCode("Index");
        if (channel == null) {
            channel = this.createIndexChannel();
        }
        return channel;
    }

    @Override
    public List<Channel> getAllChannels() {
        Querys qs = Querys.and((Query)Query.nn((String)"pid"));
        return this.select(qs, "path", null);
    }

    @Override
    public List<Channel> getTreeChannels() {
        Querys qs = Querys.and((Query)Query.nn((String)"pid"));
        Selector selector = Selector.select((String[])new String[]{"id, pid, code, icon, pic, caption, subCaption, path"}).where(qs).orderBy("path");
        return this.select(selector);
    }

    @Override
    public Channel getLastChannel(String pid) {
        Querys qs = Querys.and((Query)Query.eq((String)"pid", (Object)pid));
        return (Channel)this.selectFirst(qs, "sort desc");
    }

    @Override
    public void addChannel(Channel channel) {
        super.save((EModel)channel);
    }

    @Override
    public void modifyChannel(Channel channel) {
        super.update((EModel)channel);
    }

    @Override
    public void removeChannels(String ids) {
        super.deleteByIds(ids);
    }

    @Override
    public Channel getPervChannel(String pid, Integer sort) {
        Querys qs = Querys.and((Query)Query.eq((String)"pid", (Object)pid)).add(Query.lt((String)"sort", (Object)sort));
        return (Channel)this.selectFirst(qs, "sort desc");
    }

    @Override
    public Channel getNextChannel(String pid, Integer sort) {
        Querys qs = Querys.and((Query)Query.eq((String)"pid", (Object)pid)).add(Query.gt((String)"sort", (Object)sort));
        return (Channel)this.selectFirst(qs, "sort");
    }

    @Override
    public List<Channel> getChannels(String ids, String orderby) {
        Querys qs = Querys.and((Query)Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs, "sort " + orderby);
    }

    @Override
    public void sort(String pid, String opt, String ids) {
        Channel next;
        Channel perv;
        List<Channel> list = this.getChannels(ids, opt.equals("up") ? "asc" : "desc");
        if (opt.equals("up") ? (perv = this.getPervChannel(pid, list.get(0).getSort())) == null : (next = this.getNextChannel(pid, list.get(0).getSort())) == null) {
            return;
        }
        list.forEach(current -> this.sort(pid, opt, (Channel)((Object)current)));
    }

    @Override
    public void sort(String pid, String opt, Channel current) {
        if (opt.equals("up")) {
            Channel perv = this.getPervChannel(pid, current.getSort());
            Integer pervSort = perv.getSort();
            String pervPath = perv.getPath();
            Integer currentSort = current.getSort();
            String currentPath = current.getPath();
            current.setSort(pervSort);
            current.setPath(pervPath);
            perv.setSort(currentSort);
            perv.setPath(currentPath);
            current.update();
            perv.update();
            Querys qsPerv = Querys.and((Query)Query.like((String)"path", (Object)(pervPath + "_%")));
            Querys qsCurrent = Querys.and((Query)Query.like((String)"path", (Object)(currentPath + "_%")));
            List listPerv = this.select(qsPerv);
            listPerv.forEach(d -> d.setPath(d.getPath().replace(pervPath, currentPath)));
            List listCurrent = this.select(qsCurrent);
            listCurrent.forEach(d -> d.setPath(d.getPath().replace(currentPath, pervPath)));
            this.dbo().batchUpdate(listPerv, 100);
            this.dbo().batchUpdate(listCurrent, 100);
        } else {
            Channel next = this.getNextChannel(pid, current.getSort());
            Integer nextSort = next.getSort();
            String nextPath = next.getPath();
            Integer currentSort = current.getSort();
            String currentPath = current.getPath();
            current.setSort(nextSort);
            current.setPath(nextPath);
            next.setSort(currentSort);
            next.setPath(currentPath);
            current.update();
            next.update();
            Querys qsNext = Querys.and((Query)Query.like((String)"path", (Object)(nextPath + "_%")));
            Querys qsCurrent = Querys.and((Query)Query.like((String)"path", (Object)(currentPath + "_%")));
            List listNext = this.select(qsNext);
            listNext.forEach(d -> d.setPath(d.getPath().replace(nextPath, currentPath)));
            List listCurrent = this.select(qsCurrent);
            listCurrent.forEach(d -> d.setPath(d.getPath().replace(currentPath, nextPath)));
            this.dbo().batchUpdate(listNext, 1000);
            this.dbo().batchUpdate(listCurrent, 1000);
        }
    }

    @Override
    public List<Channel> getChildren(String id) {
        Querys qs = Querys.and((Query)Query.eq((String)"pid", (Object)id));
        return this.select(qs, "sort", null);
    }

    @Override
    public List<String> getChildrenIds(String id) {
        Channel parent = (Channel)this.findById(id);
        Querys qs = Querys.and((Query)Query.like((String)"path", (Object)(parent.getPath() + "%")));
        return this.selectCol(qs, "id");
    }
}

