/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.site.controller;

import com.google.inject.Inject;
import com.jfinal.template.Engine;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EControllerSite;
import itez.kit.EStr;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.service.SiteTempService;
import itez.plat.wrapper.controller.EControllerMgr;
import java.util.List;

@ControllerDefine(key="/site/temp", summary="\u7f51\u7ad9\u6a21\u677f", view="/")
public class SiteTempController
extends EControllerMgr {
    @Inject
    SiteTempService tempSer;

    public void index() {
        List<SiteTemp> temps = this.tempSer.getTemps();
        this.setAttr("temps", temps);
        this.render("temp.html");
    }

    public void init() {
        this.tempSer.init();
        this.redirect(this.attr().getCtrl());
    }

    public void del() {
        String fileName = this.getPara("fileName");
        boolean does = this.tempSer.del(fileName);
        if (!does) {
            this.setFlashMsg("\u5220\u9664\u5931\u8d25\uff01");
        } else {
            this.clearTemp(fileName);
        }
        this.redirect(this.attr().getCtrl());
    }

    public void saveas() {
        String fromName = this.getPara("f");
        String toName = this.getPara("t");
        this.tempSer.saveas(fromName, toName);
        this.redirect(this.attr().getCtrl());
    }

    public void edit() {
        SiteTemp temp;
        String act;
        String fileName = this.getPara("fileName");
        if (EStr.isEmpty((String)fileName)) {
            act = "create";
            temp = new SiteTemp();
            temp.setFileName("new.html");
            temp.setSpace(0L);
            temp.setContent("<html></html>");
        } else {
            act = "modify";
            temp = this.tempSer.getTemp(fileName);
        }
        this.setAttr("act", act);
        this.setAttr("temp", temp);
        this.render("tempContent.html");
    }

    public void editDo() {
        String act = this.getPara("act");
        String fileName = this.getPara("fileName");
        String content = this.getPara("content");
        SiteTemp temp = new SiteTemp();
        temp.setFileName(fileName);
        temp.setContent(content);
        if (act.equals("create")) {
            this.tempSer.create(temp);
        } else if (act.equals("modify")) {
            this.tempSer.modify(temp);
        }
        this.clearTemp(fileName);
        this.redirect(this.attr().getCtrl());
    }

    private void clearTemp(String view) {
        String viewPath = "/" + this.attr().getDomain() + "/" + view;
        Engine engine = EControllerSite.getEngine();
        try {
            engine.removeTemplateCache(viewPath);
        }
        catch (Exception e) {
            System.out.println("\u6a21\u677f\u7f13\u5b58\u4e0d\u5b58\u5728\uff01");
        }
    }
}

