/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.google.inject.Singleton;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IComp;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;
import java.util.List;

@Define
@Singleton
public class DeptServiceImpl
extends EModelService<Dept>
implements DeptService {
    @Cache.able(cache="DEPT_BY_ID", key="#(id)")
    public Dept findById(String id) {
        return (Dept)super.findById(id);
    }

    @Override
    public Dept findByTmid(Object tmid) {
        Querys qs = Querys.and((Query)Query.eq((String)"tmid", (Object)tmid));
        return (Dept)this.selectFirst(qs);
    }

    @Override
    public Dept createRootDept() {
        return this.createRootDept(this.$comp());
    }

    @Override
    public Dept createRootDept(IComp comp) {
        Dept dept = this.getRootDept(comp.getId());
        if (dept != null) {
            return dept;
        }
        dept = new Dept();
        dept.setCompId(comp.getId());
        dept.setCaption(comp.getCaption());
        dept.setSummary("\u9ed8\u8ba4\u90e8\u95e8");
        dept.setSort(1);
        dept.setPath(EStr.addPrefix((int)1, (int)3));
        dept.save();
        return dept;
    }

    @Override
    @Cache.able(key="#(compId)")
    public Dept getRootDept(String compId) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.nu((String)"pid"));
        return (Dept)this.selectFirst(qs);
    }

    @Override
    @Cache.able(cache="dept_all", key="#(compId)")
    public List<Dept> getAllDepts(String compId) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.nn((String)"pid"));
        return this.select(qs, "path", null);
    }

    @Override
    public List<Dept> getAllDepts(String compId, String pid) {
        Dept dept = (Dept)super.findById(pid);
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(dept.getPath() + "_%")));
        return this.select(qs, "path", null);
    }

    @Override
    public List<Dept> getSubDepts(String compId, String pid) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.eq((String)"pid", (Object)pid));
        return this.select(qs);
    }

    @Override
    public List<Dept> getDepts(String compId, String ids) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs);
    }

    @Override
    public List<Dept> getDepts(String compId, String ids, String orderby) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs, "sort " + orderby);
    }

    @Override
    public Dept getLastDept(String pid) {
        return this.getLastDept(this.$comp().getId(), pid);
    }

    @Override
    public Dept getLastDept(String compId, String pid) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.eq((String)"pid", (Object)pid));
        return (Dept)this.selectFirst(qs, "sort desc");
    }

    @Override
    @Cache.del(cache="dept_all", key="#(dept.compId)")
    public void addDept(Dept dept) {
        if (EStr.isEmpty((String)dept.getCompId())) {
            dept.setCompId(this.$comp().getId());
        }
        dept.save();
    }

    @Override
    @Cache.del(cache="dept_all", key="#(dept.compId)")
    public void modifyDept(Dept dept) {
        dept.update();
        ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
    }

    @Override
    @Cache.del(cache="dept_all", key="#(compId)")
    public void removeDepts(String compId, String ids) {
        List<Dept> list = this.getDepts(compId, ids);
        list.forEach(dept -> {
            dept.disable();
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
        });
    }

    @Override
    public Dept getPervDept(String compId, String pid, Integer sort) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.eq((String)"pid", (Object)pid)).add(Query.lt((String)"sort", (Object)sort));
        return (Dept)this.selectFirst(qs, "sort desc");
    }

    @Override
    public Dept getNextDept(String compId, String pid, Integer sort) {
        Querys qs = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.eq((String)"pid", (Object)pid)).add(Query.gt((String)"sort", (Object)sort));
        return (Dept)this.selectFirst(qs, "sort");
    }

    @Override
    @Cache.del(cache="dept_all", key="#(compId)")
    public void sort(String compId, String pid, String opt, String ids) {
        Dept nextDept;
        Dept pervDept;
        List<Dept> list = this.getDepts(compId, ids, opt.equals("up") ? "asc" : "desc");
        if (opt.equals("up") ? (pervDept = this.getPervDept(compId, pid, list.get(0).getSort())) == null : (nextDept = this.getNextDept(compId, pid, list.get(0).getSort())) == null) {
            return;
        }
        list.forEach(dept -> this.sort(compId, pid, opt, (Dept)((Object)dept)));
    }

    @Override
    public void sort(String compId, String pid, String opt, Dept dept) {
        if (opt.equals("up")) {
            Dept pervDept = this.getPervDept(compId, pid, dept.getSort());
            Integer pervSort = pervDept.getSort();
            String pervPath = pervDept.getPath();
            Integer deptSort = dept.getSort();
            String deptPath = dept.getPath();
            dept.setSort(pervSort);
            dept.setPath(pervPath);
            pervDept.setSort(deptSort);
            pervDept.setPath(deptPath);
            dept.update();
            pervDept.update();
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)pervDept.getId());
            Querys qsPerv = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(pervPath + "_%")));
            Querys qsDept = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(deptPath + "_%")));
            List listPerv = this.select(qsPerv);
            listPerv.forEach(d -> {
                d.setPath(d.getPath().replace(pervPath, deptPath));
                ECacheKit.remove((String)"DEPT_BY_ID", (Object)d.getId());
            });
            List listDept = this.select(qsDept);
            listDept.forEach(d -> {
                d.setPath(d.getPath().replace(deptPath, pervPath));
                ECacheKit.remove((String)"DEPT_BY_ID", (Object)d.getId());
            });
            this.dbo().batchUpdate(listPerv, 100);
            this.dbo().batchUpdate(listDept, 100);
        } else {
            Dept nextDept = this.getNextDept(compId, pid, dept.getSort());
            Integer nextSort = nextDept.getSort();
            String nextPath = nextDept.getPath();
            Integer deptSort = dept.getSort();
            String deptPath = dept.getPath();
            dept.setSort(nextSort);
            dept.setPath(nextPath);
            nextDept.setSort(deptSort);
            nextDept.setPath(deptPath);
            dept.update();
            nextDept.update();
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)dept.getId());
            ECacheKit.remove((String)"DEPT_BY_ID", (Object)nextDept.getId());
            Querys qsNext = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(nextPath + "_%")));
            Querys qsDept = Querys.and((Query)Query.eq((String)"compId", (Object)compId)).add(Query.like((String)"path", (Object)(deptPath + "_%")));
            List listNext = this.select(qsNext);
            listNext.forEach(d -> {
                d.setPath(d.getPath().replace(nextPath, deptPath));
                ECacheKit.remove((String)"DEPT_BY_ID", (Object)d.getId());
            });
            List listDept = this.select(qsDept);
            listDept.forEach(d -> {
                d.setPath(d.getPath().replace(deptPath, nextPath));
                ECacheKit.remove((String)"DEPT_BY_ID", (Object)d.getId());
            });
            this.dbo().batchUpdate(listNext, 1000);
            this.dbo().batchUpdate(listDept, 1000);
        }
    }
}

