package itez.plat.wrapper.launch;

import com.jfinal.config.Constants;
import com.jfinal.config.Interceptors;
import com.jfinal.template.Engine;

import itez.core.launch.JWinnerConfig;
import itez.core.runtime.service.ServiceManager;
import itez.kit.EProp;
import itez.plat.base.service.ModuleService;
import itez.plat.base.util.ConfigKit;

/**
 * 平台项目[plat] 初始化配置文件
 * 
 * @author netwild
 *
 */
public class PlatConfig extends JWinnerConfig {

	/**
	 * 全局参数配置
	 */
	@Override
	public void configConstant(Constants me) {
		super.configConstant(me);
	}
	
	/**
	 * 模板引擎配置
	 */
	@Override
	public void configEngine(Engine me) {
		super.configEngine(me);
		me.addSharedFunction(EProp.TempLayoutPath + "/layout_base.html");
		me.addSharedFunction(EProp.TempLayoutPath + "/layout_main.html");
		me.addSharedObject("PropUtil", new EProp());
		me.addSharedObject("ConfigUtil", new ConfigKit());
	}
	
	/**
	 * 拦截器配置
	 */
	@Override
	public void configInterceptor(Interceptors me) {
		super.configInterceptor(me);
	}
	
	/**
	 * 启动完成后运行
	 */
	@Override
	public void afterJFinalStart() {
		super.afterJFinalStart();

		//每次启动服务器后，自动同步模块配置数据
		ModuleService ms = (ModuleService)ServiceManager.me.getService(ModuleService.class);
		ms.initModuleData();
	}
	
	//本地调试入口
	public static void main(String[] args) {
		run();
		//run(new Server()); //Server.java extends LocalServer_Jetty
	}

}
