package itez.plat.wrapper.interceptor;

import java.util.List;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.EContext;
import itez.core.runtime.service.ServiceManager;
import itez.core.runtime.session.EAttr;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.Menu;
import itez.plat.base.service.MenuService;

public class MenuInterceptor implements Interceptor {
	
	@Override
	public void intercept(Invocation inv) {
		EController controller = (EController)inv.getController();
		EAttr attr = EContext.getAttr();
		
		final String menuActiveKey = "_m_";

		MenuService ms = ServiceManager.me.getService(MenuService.class);
		
		String clickMenu = controller.getPara(menuActiveKey);
		
		if(EStr.notEmpty(clickMenu)){
			if(clickMenu.equals("_index_")) clickMenu = "";
			EContext.getSession().setAttribute(menuActiveKey, clickMenu);
		}else{
			clickMenu = EContext.getSession().getAttr(menuActiveKey);
		}
		
		if(EStr.notEmpty(clickMenu)){
			int at = clickMenu.lastIndexOf("_");
			at = at == -1 ? 0 : at+1;
			String menuId = clickMenu.substring(at);
			String menuActiveName = ms.findById(menuId).getCaption();
			attr.setItem("currentMenuId", clickMenu);
			attr.setItem("currentMenuName", menuActiveName);
			attr.setItem("currentMenuStr", String.format("%s=%s", menuActiveKey, clickMenu));
		}
		
		List<Menu> menus = ms.getCompMenus(attr.getComp().getId());
		if(menus != null) attr.setItem("menusData", menus);
		
		inv.invoke();
	}

}
