package itez.plat.site.service.impl;

import java.io.File;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import com.jfinal.kit.PathKit;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.kit.EFile;
import itez.kit.EProp;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.service.SiteTempService;

@Define
@Singleton
public class SiteTempServiceImpl extends EService implements SiteTempService {

	public boolean checkTemp(String view){
		String path = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + view;
		File temp = new File(path);
		return temp.exists();
	}
	
	public List<SiteTemp> getTemps(){
		List<SiteTemp> temps = Lists.newArrayList();
		String root = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain();
		File dir = new File(root);
		if(!dir.exists()) return temps;
		if(dir.isFile()) return temps;
		File[] list = dir.listFiles();
		if(list == null || list.length == 0) return temps;
		for(File file : list){
			if(file.isDirectory()) continue;
			SiteTemp temp = new SiteTemp();
			temp.setFileName(file.getName());
			temp.setFilePath(file.getAbsolutePath());
			temp.setContent("");
			temp.setSpace(file.length());
			temps.add(temp);
		}
		return temps;
	}

	public void init(){
		String[] tempList = { "index.html", "channel.html", "content.html" };
		String defPath = PathKit.getWebRootPath() + "/common/doc/site/temp";
		File defDir = new File(defPath);
		if(!defDir.exists()) return;
		if(defDir.isFile()) return;
		
		String destPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain();
		File destDir = new File(destPath);
		try {
			if(!destDir.exists()) destDir.mkdirs();
			for(String temp : tempList){
				Files.copy(new File(defPath + File.separator + temp), new File(destPath + File.separator + temp));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public boolean del(String fileName){
		String destPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + fileName;
		File file = new File(destPath);
		return file.delete();
	}
	
	public void saveas(String fromName, String toName){
		String fromPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + fromName;
		File fromFile = new File(fromPath);
		String toPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + toName;
		File toFile = new File(toPath);
		try {
			Files.copy(fromFile, toFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public SiteTemp getTemp(String fileName){
		String destPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + fileName;
		File file = new File(destPath);
		SiteTemp temp = new SiteTemp();
		temp.setFileName(fileName);
		temp.setFilePath(file.getAbsolutePath());
		temp.setSpace(file.length());
		temp.setContent(EFile.read(file));
		return temp;
	}
	
	public void create(SiteTemp temp){
		String destPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + temp.getFileName();
		File file = new File(destPath);
		if(file.exists()) return;
		try {
			file.createNewFile();
			EFile.write(file, temp.getContent());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void modify(SiteTemp temp){
		String destPath = EProp.SiteTempRoot + File.separator + EContext.getAttr().getDomain() + File.separator + temp.getFileName();
		File file = new File(destPath);
		if(!file.exists()) return;
		try {
			EFile.write(file, temp.getContent());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
