package itez.plat.site.controller;

import java.util.List;

import com.jfinal.upload.UploadFile;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.fileup.EFileKit;
import itez.kit.fileup.FileItem;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/resc", summary = "网站资源", view = "/")
public class SiteRescController extends EControllerMgr {

	public void index(){
		List<FileItem> files = EFileKit.list(getSubPath());
		setAttr("files", files);
		render("resc.html");
	}
	
	public void del(){
		String fileName = getPara("fileName");
		boolean does = EFileKit.remove(fileName);
		if(!does) setFlashMsg("删除失败：" + fileName);
		redirect(attr().getCtrl());
	}
	
	public void upload(){
		UploadFile fileUp = getFile("resFile");
		if(fileUp != null) EFileKit.upload(fileUp.getFile(), getSubPath(), false);
		redirect(attr().getCtrl());
	}
	
	private String getSubPath(){
		return attr().getDomain() + "/res";
	}
	
}
