package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.SiteConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/content", summary = "网站文章管理", view = "/")
public class SiteContentController extends EControllerMgr {

	@Inject
	ChannelService channelSer;
	
	@Inject
	ContentService contentSer;
	
	public void index(){
		Channel indexChannel = channelSer.findByCode(SiteConfig.INDEX_CODE);
		List<Channel> channels = channelSer.getTreeChannels();
		String pid = getPara("pid", indexChannel.getId());
		List<Content> contents = contentSer.getByChannelId(pid);
		setAttr("pid", pid);
		setAttr("indexChannel", indexChannel);
		setAttr("channels", channels);
		setAttr("contents", contents);
		render("content.html");
	}
	
	public void addContent(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";
		
		String pid = getPara("pid");
		
		Content content = new Content();
		content.setChannelId(pid);
		content.setCaption(getPara("caption"));
		content.setSubCaption(getPara("subCaption"));
		content.setSummary(getPara("summary"));
		content.setAuthor(getPara("author"));
		content.setContent(getPara("content"));
		content.setSort(0);
		if(EStr.notEmpty(picUrl)) content.setPic(picUrl);
		
		contentSer.save(content);
		
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void modifyContent(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";

		String id = getPara("id");
		Content content = contentSer.findById(id);
		String pid = content.getChannelId();

		content.setCaption(getPara("caption"));
		content.setSubCaption(getPara("subCaption"));
		content.setSummary(getPara("summary"));
		content.setAuthor(getPara("author"));
		content.setContent(getPara("content"));
		content.setSort(0);
		if(EStr.notEmpty(picUrl)) content.setPic(picUrl);
		
		contentSer.update(content);
		
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void removeContent(){
		String pid = getPara("pid");
		String ids = getPara("ids");
		contentSer.deleteByIds(ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
}
