package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/channel", summary = "网站栏目管理", view = "/")
public class SiteChannelController extends EControllerMgr {

	@Inject
	ChannelService channelSer;
	
	public void index(){
		Channel indexChannel = channelSer.getIndexChannel();
		List<Channel> channels = channelSer.getAllChannels();
		setAttr("pid", getPara("pid", indexChannel.getId()));
		setAttr("indexChannel", indexChannel);
		setAttr("channels", channels);
		render("channel.html");
	}
	
	public void addChannel(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";
		
		String pid = getPara("pid");
		Channel parent = channelSer.findById(pid);
		Channel last = channelSer.getLastChannel(pid);
		Integer sort = last == null ? 1 : last.getSort() + 1;
		String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
		
		Channel channel = new Channel();
		channel.setPid(pid);
		channel.setPath(path);
		channel.setSort(sort);
		
		String code = getPara("code");
		String icon = getPara("icon");
		String caption = getPara("caption");
		String subCaption = getPara("subCaption");
		String content = getPara("content");
		String channelTemp = getPara("channelTemp");
		String contentTemp = getPara("contentTemp");
		channel.setCode(code);
		channel.setIcon(icon);
		channel.setPic(picUrl);
		channel.setCaption(caption);
		channel.setSubCaption(subCaption);
		channel.setContent(content);
		channel.setChannelTemp(channelTemp);
		channel.setContentTemp(contentTemp);
		
		channelSer.addChannel(channel);
		
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void modifyChannel(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";
		
		String id = getPara("id");
		Channel channel = channelSer.findById(id);
		String pid = channel.getPid();
		
		String code = getPara("code");
		String icon = getPara("icon");
		String caption = getPara("caption");
		String subCaption = getPara("subCaption");
		String content = getPara("content");
		String channelTemp = getPara("channelTemp");
		String contentTemp = getPara("contentTemp");
		
		channel.setCode(code);
		channel.setIcon(icon);
		if(EStr.notEmpty(picUrl)) channel.setPic(picUrl);
		channel.setCaption(caption);
		channel.setSubCaption(subCaption);
		channel.setContent(content);
		channel.setChannelTemp(channelTemp);
		channel.setContentTemp(contentTemp);
		
		channelSer.modifyChannel(channel);
		
		redirect(attr().getCtrl() + "/?pid=" + pid);
	}
	
	public void removeChannel(){
		String pid = getPara("pid");
		String ids = getPara("ids");
		channelSer.removeChannels(ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void sortChannel(){
		String pid = getPara("pid");
		String opt = getPara("opt");
		String ids = getPara("ids");
		channelSer.sort(pid, opt, ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
}
