package itez.plat.msg.service;

import java.util.Arrays;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.jfinal.kit.Kv;

public enum MsgType {

	P2P(10, "私信"), 
	SYS(20, "系统"), 
		NOTICE(21, "通知"), 
		TODO(22, "待办"), 
	DYNAMIC(30, "动态"), 
		RE(31, "回复我"), 
		AT(32, "提到我"), 
		UP(33, "点赞我");
	
	private Integer value;
	private String caption;
	
	private MsgType(Integer value, String caption){
		this.value = value;
		this.caption = caption;
	}
	
	public static MsgType parse(Integer value){
		MsgType[] enumArray = MsgType.values();
		MsgType item = Arrays.stream(enumArray).filter(n -> n.getValue() == value).findAny().orElse(null);
		return item;
	}
	
	@Override
	public String toString() {
		return caption;
	}
	
	public Integer getValue(){
		return value;
	}
	
	public String getCaption(){
		return caption;
	}
	
	public static List<Kv> groupList;
	static{
		groupList = Lists.newArrayList();
		groupList.add(Kv.by("value", MsgType.P2P.getValue()).set("caption", MsgType.P2P.getCaption()).set("code", MsgType.P2P.name()));
		groupList.add(Kv.by("value", MsgType.SYS.getValue()).set("caption", MsgType.SYS.getCaption()).set("code", MsgType.SYS.name()));
		groupList.add(Kv.by("value", MsgType.DYNAMIC.getValue()).set("caption", MsgType.DYNAMIC.getCaption()).set("code", MsgType.DYNAMIC.name()));
	}
	
}
