package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Perm;
import itez.plat.base.model.Role;
import itez.plat.base.model.User;
import itez.plat.base.service.PermService;
import itez.plat.base.service.RoleService;
import itez.plat.base.service.UserIOService;
import itez.plat.base.service.UserService;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserServiceImpl extends EModelService<User> implements UserService, IUserService {

	@Inject
	UserIOService uioService;

	@Inject
	RoleService roleService;

	@Inject
	PermService permService;
	
	private User emptyUser;
	
	public UserServiceImpl(){
		emptyUser = new User();
		emptyUser.setId(null);
		emptyUser.setCaption("匿名用户");
		emptyUser.setUsed(1);
	}
	
	@Override
	public User getEmptyUser() {
		return this.emptyUser;
	}

	@Override
	@Cache.able(cache="USER_BY_ID", key="#(userId)")
	public User findById(String userId) {
		return super.findById(userId);
	}

	@Override
	@Cache.able(cache="USER_BY_EMAIL", key="#(email)")
	public User findByEmail(String email) {
		return super.selectFirst(Querys.and(Query.eq("email", email)));
	}

	@Override
	@Cache.able(cache="USER_BY_PHONE", key="#(phone)")
	public User findByPhone(String phone) {
		return super.selectFirst(Querys.and(Query.eq("phone", phone)));
	}

	@Cache.able(cache="USER_BY_LOGIN", key="#(domain).#(loginName)")
	public User findByLogin(String domain, String loginName) {
		Querys qs1 = Querys.or(Query.eq("domain", domain)).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("loginName", loginName));
		return super.selectFirst(qs2);
	}

	@Override
	public User findByLogin(String domain, String loginName, String passWord) {
		User user = findByLogin(domain, loginName);
		if(user != null){
			String pass = HashKit.md5(String.format("%s%s", passWord, user.getSalt()));
			if(pass.equals(user.getLoginPass())) return user;
		}
		return null;
	}

	@Override
	public boolean checkRole(IUser user, String roleCode) {
		if(user.getLevel() == 2) return true;
		if(EStr.isEmpty(roleCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		return roles.stream().anyMatch(r -> r.getCode().equals(roleCode));
	}

	@Override
	public boolean checkRoles(IUser user, String... roleCodeArr) {
		if(user.getLevel() == 2) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!rolesHas.retainAll(rolesReq)) return false;
		else return rolesReq.size() == rolesHas.size();
	}

	@Override
	public boolean checkRolesAny(IUser user, String... roleCodeArr) {
		if(user.getLevel() == 2) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return rolesHas.retainAll(rolesReq);
	}

	@Override
	public boolean checkPerm(IUser user, String permCode) {
		if(user.getLevel() == 2) return true;
		if(EStr.isEmpty(permCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		return perms.stream().anyMatch(p -> p.getCode().equals(permCode));
	}

	@Override
	public boolean checkPerms(IUser user, String... permCodeArr) {
		if(user.getLevel() == 2) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!permsHas.retainAll(permsReq)) return false;
		else return permsReq.size() == permsHas.size();
	}

	@Override
	public boolean checkPermsAny(IUser user, String... permCodeArr) {
		if(user.getLevel() == 2) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return permsHas.retainAll(permsReq);
	}
	
	public List<User> getUsers(String domain, String ids){
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	/**
	 * 返回指定部门的成员列表
	 * @param compId
	 * @param deptId
	 * @return
	 */
	public List<User> getInsUsers(String domain, String deptId){
		Querys qs = Querys.and(Query.eq("member", 1)).add(Query.eq("domain", domain)).add(Query.eq("deptId", deptId)).add(Query.eq("used", 1)).add(Query.ne("level", 2));
		List<User> list = select(qs, "level desc, id", null, "id, caption, loginName, roleIds");
		return list;
	}
	
	/**
	 * 添加新用户
	 * @param user
	 */
	public void add(User user, String loginPass){
		uioService.addUser(user, loginPass);
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 */
	public void modify(User user){
		uioService.modifyUser(user);
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	public void remove(String domain, String ids){
		List<User> users = getUsers(domain, ids);
		users.forEach(user -> uioService.removeUser(user));
	}
	
	/**
	 * 微信相关
	 */
	
	public User findByUnionId(String unionId){
		return super.selectFirst(Querys.and(Query.eq("unionId", unionId)));
	}
	
	public User findByWxOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxOpenId", openId)));
	}
	
	public User findByWxaOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxaOpenId", openId)));
	}
	
	public User findByWxeOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxeOpenId", openId)));
	}

	@Override
	public User loginByTypeName(String type, String loginName) {
		Querys qs = Querys.and(Query.eq("type", type)).add(Query.eq("loginName", loginName));
		return selectFirst(qs);
	}

	@Override
	public User loginByTypeNameOrIdNum(String type, String loginName) {
		Querys qs1 = Querys.or(Query.eq("idNum", loginName)).add(Query.eq("loginName", loginName));
		Querys qs2 = Querys.and(Query.eq("type", type)).add(qs1);
		return selectFirst(qs2);
	}

}