package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Post;
import itez.plat.base.service.PostService;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PostServiceImpl extends EModelService<Post> implements PostService {

	@Override
	@Cache.able(cache="POST_BY_ID", key="#(id)")
	public Post findById(String id) {
		return super.findById(id);
	}
	
	/**
	 * 返回tmid对应的机构
	 * @param tmid
	 * @return
	 */
	public Post findByTmid(Object tmid) {
		Querys qs = Querys.and(Query.eq("tmid", tmid));
		return selectFirst(qs);
	}

	public void addPost(Post post){
		post.save();
	}

}