package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Config;
import itez.plat.base.model.ConfigDefault;
import itez.plat.base.service.ConfigDefaultService;
import itez.plat.base.service.ConfigService;

import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ConfigServiceImpl extends EModelService<Config> implements ConfigService {

	@Inject
	ConfigDefaultService configDefService;

	@Cache.able(cache="Config", key="#(code)")
	public ConfigDefault getByCode(String code){
		ConfigDefault def = configDefService.getByCode(code);
		if(def == null) throw new RuntimeException("参数不存在：" + code);
		Querys qs = Querys.and(Query.eq("code", code));
		Config cfg = selectFirst(qs);
		if(cfg == null){
			return def;
		}else{
			return def.setValue(cfg.getValue());
		}
	}

	public String getValue(String code){
		ConfigDefault def = getByCode(code);
		return def.getValue();
	}

	public Boolean getBool(String code){
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("boolean")){
			return value.equals("1");
		}else{
			return false;
		}
	}

	@Override
	public Integer getInt(String code) {
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("int")){
			return EStr.isNull(value) ? 0 : Integer.parseInt(value);
		}else{
			return 0;
		}
	}

}