/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import itez.core.runtime.EContext;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EHttp;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.model.Post;
import itez.plat.base.model.User;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.PostService;
import itez.plat.base.service.UserIOService;
import itez.plat.base.service.UserServiceTm3;
import java.util.Map;

@Define
@Singleton
public class UserServiceTm3Impl
extends EModelService<User>
implements UserServiceTm3 {
    @Inject
    UserIOService uioService;
    @Inject
    DeptService deptService;
    @Inject
    PostService postService;

    @Override
    @Cache.able
    public User getByTm3Uid(String uid) {
        Querys qs = Querys.and((Query)Query.eq((String)"tmid", (Object)uid));
        return (User)this.selectFirst(qs);
    }

    @Override
    public User addByTm3User(User user, String loginPass) {
        this.uioService.addUser(user, loginPass);
        return user;
    }

    @Override
    public User updateByTm3User(User user, String loginPass) {
        this.uioService.modifyUser(user, loginPass);
        return user;
    }

    @Override
    public Dept syncDeptByTm3(String deptId, String deptCaption) {
        Dept rootDept = this.deptService.createRootDept();
        Dept dept = this.deptService.findByTmid(deptId);
        Dept last = this.deptService.getLastDept(rootDept.getId());
        Integer sort = last == null ? 1 : last.getSort() + 1;
        String path = String.format("%s_%s", rootDept.getPath(), EStr.addPrefix((int)sort, (int)3));
        if (dept == null) {
            dept = new Dept();
            dept.setPid(rootDept.getId());
            dept.setCaption(deptCaption);
            dept.setLevel(0);
            dept.setTmid(deptId);
            dept.setSort(sort);
            dept.setPath(path);
            this.deptService.addDept(dept);
        }
        return dept;
    }

    @Override
    public Post syncPostByTm3(String postId, String postCaption) {
        Post post = this.postService.findByTmid(postId);
        if (post == null) {
            post = new Post();
            post.setTmid(postId);
            post.setCaption(postCaption);
            post.setSort(0);
            post.setSign("");
            this.postService.addPost(post);
        }
        return post;
    }

    @Override
    public ERet loginCheck(String loginName, String loginPass) {
        String service = "/plat/user";
        String action = "Vali";
        String url = String.format("%s%s?action=%s&loginName=%s&loginPass=%s", EProp.TM_Url, service, action, loginName, loginPass);
        String res = EHttp.me.get(url);
        if (EStr.notEmpty((String)res)) {
            ERet resJson = ERet.parse((String)res);
            if (resJson.isOk()) {
                ERet ret = ERet.ok((String)("TM3\u8d26\u53f7\u9a8c\u8bc1\u901a\u8fc7\uff1a" + EProp.TM_Url));
                JSONObject userObj = (JSONObject)resJson.get((Object)"user");
                String uid = (String)userObj.getObject("id", String.class);
                String uname = (String)userObj.getObject("name", String.class);
                Map role = (Map)userObj.getObject("role", Map.class);
                Integer level = (Integer)((Object)role.getOrDefault("level", "1"));
                String qxStr = (String)role.get("qxStr");
                Map dept = (Map)userObj.getObject("logicOrg", Map.class);
                String deptId = (String)dept.get("dm");
                String deptCaption = (String)dept.get("mc");
                Dept deptNative = this.syncDeptByTm3(deptId, deptCaption);
                String postId = (String)userObj.getObject("gwid", String.class);
                String postCaption = (String)userObj.getObject("gwmc", String.class);
                Post postNative = this.syncPostByTm3(postId, postCaption);
                User user = this.getByTm3Uid(uid);
                if (user != null) {
                    user.setLevel(level == 6 ? 1 : 0);
                    user.setRoleIds(qxStr);
                    user.setDeptId(deptNative.getId());
                    user.setPostId(postNative.getId());
                    user = this.updateByTm3User(user, loginPass);
                } else {
                    user = new User();
                    user.setTmid(uid);
                    user.setDomain(this.$domain());
                    user.setType(1);
                    user.setCaption(uname);
                    user.setLoginName(loginName);
                    user.setLevel(level == 6 ? 1 : 0);
                    user.setRoleIds(qxStr);
                    user.setDeptId(deptNative.getId());
                    user.setPostId(postNative.getId());
                    user = this.addByTm3User(user, loginPass);
                }
                EContext.getSession().setAttribute("postTempId", resJson.get((Object)"postTempId"));
                EContext.getSession().setAttribute("TM_Level", (Object)level);
                EContext.getSession().setAttribute("TM_MyOrg", userObj.getObject("myOrg", Map.class));
                ret.set((Object)"user", (Object)user);
                return ret;
            }
            return ERet.fail((String)resJson.getMsg());
        }
        return ERet.fail((String)"\u8fde\u63a5TM3\u670d\u52a1\u5668\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

