/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.controller;

import com.google.inject.Inject;
import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.upload.UploadFile;
import itez.core.runtime.auth.AuthCode;
import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.service.common.ICompService;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.runtime.session.ESessionBase;
import itez.core.runtime.session.TokenManager;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.El;
import itez.kit.fileup.EFileKit;
import itez.plat.base.model.Comp;
import itez.plat.base.util.ConfigKit;
import java.io.File;

@ControllerDefine(key="/", summary="\u5e73\u53f0\u9996\u9875", view="/")
public class IndexController
extends EController {
    @Inject
    ICompService compService;
    @Inject
    IUserService userService;

    @AuthRequire.Logined
    public void index() {
        Comp comp = (Comp)this.attr().getComp();
        if (EStr.notEmpty((String)comp.getIndex())) {
            this.redirect(this.attr().getIndexUrl());
            return;
        }
        String tempPath = "";
        String selfTempExpr = comp.getSelfTempExp();
        if (EStr.notEmpty((String)selfTempExpr)) {
            ERet context = ERet.create((Object)"attr", (Object)this.attr()).set((Object)"user", (Object)this.session().getUser()).set((Object)"comp", (Object)comp);
            tempPath = El.me.exec(selfTempExpr, ERet.create((Object)"attr", (Object)context));
        }
        if (EStr.isEmpty((String)tempPath)) {
            tempPath = "index.html";
        }
        if (comp.getSelfTemp() == 1) {
            tempPath = String.format("%s/%s", comp.getDomain(), tempPath);
        }
        this.render(tempPath);
    }

    @AuthRequire.Logined
    public void test01() {
        this.render("test/01.html");
    }

    @AuthRequire.Logined
    public void test02() {
        this.render("test/02.html");
    }

    @Clear
    public void login() {
        String from = this.getPara("from");
        if (EStr.notEmpty((String)from)) {
            this.setAttr("previousPageUrl", from);
        }
        this.render(EProp.TempLoginPath);
    }

    @Clear
    public void valicode() {
        this.renderCaptcha();
    }

    @Before(value={NotAction.class})
    private ERet loginLogic(ESessionBase.ClientType type) {
        if (type == ESessionBase.ClientType.PLAT && ConfigKit.getBool("CaptchaAble").booleanValue() && !this.validateCaptcha("valicode")) {
            return ERet.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String loginName = this.getPara("loginName");
        String loginPass = this.getPara("loginPass");
        if (EStr.isEmpty((String)loginName) || EStr.isEmpty((String)loginPass)) {
            return ERet.fail((String)"\u7528\u6237\u540d\u53ca\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ERet ret = ERet.create();
        IUser user = this.userService.findByLogin(this.attr().getDomain(), loginName, loginPass);
        if (null == user) {
            return ret.setFail().setMsg("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (user.getUsed() != 1) {
            return ret.setFail().setMsg("\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
        }
        ret.setOk().set((Object)"user", (Object)user);
        return ret;
    }

    @Clear
    public void login4plat() {
        String previousPageUrl = this.getPara("previousPageUrl");
        ERet ret = this.loginLogic(ESessionBase.ClientType.PLAT);
        if (ret.isFail()) {
            this.setFlashMsg(ret.getMsg());
            this.setFlashAttr("previousPageUrl", previousPageUrl);
            this.redirect(this.attr().getLoginUrl());
        } else if (ret.isOk()) {
            IUser user = (IUser)ret.getAs((Object)"user");
            this.session().setLogined(Boolean.valueOf(true));
            this.session().setUid(user.getId());
            String url = EStr.ifEmpty((String)previousPageUrl, (String)this.attr().getIndexUrl());
            this.redirect(url);
        }
    }

    @Clear
    public void login4app() {
        ERet ret = this.loginLogic(ESessionBase.ClientType.APP);
        if (ret.isOk()) {
            IUser user = (IUser)ret.getAs((Object)"user");
            String tokenCode = TokenManager.me.createToken(user.getId()).toString();
            ret.set((Object)"jwtoken", (Object)tokenCode);
        }
        this.renderJson(ret);
    }

    @Clear
    public void logout() {
        this.session().setLogined(Boolean.valueOf(false));
        this.session().setUid(null);
        this.setFlashMsg("\u8eab\u4efd\u5df2\u6ce8\u9500\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        this.redirect(this.attr().getLoginUrl());
    }

    @Clear
    public void error() {
        AuthCode authCode = AuthCode.valueOf((String)this.getPara("authCode"));
        String errMsg = this.getPara("errMsg");
        String helpUrl = this.getPara("helpUrl");
        if (EStr.isEmpty((String)errMsg)) {
            this.renderErr(authCode);
        } else if (EStr.isEmpty((String)helpUrl)) {
            this.renderErrMsg(authCode, errMsg);
        } else {
            this.renderErrHelp(authCode, errMsg, helpUrl);
        }
    }

    @Clear
    public void ueditorUpload() {
        String action = this.getPara("action", "config");
        if ("config".equals(action)) {
            this.render("/base/asset/js/ueditorConfig.json");
        } else {
            UploadFile upfile = this.getFile("upfile");
            if (upfile != null) {
                String fileName = upfile.getFileName();
                String url = EFileKit.upload((File)upfile.getFile());
                ERet ret = ERet.create();
                ret.set((Object)"state", (Object)"SUCCESS");
                ret.set((Object)"url", (Object)url);
                ret.set((Object)"title", (Object)fileName);
                ret.set((Object)"original", (Object)upfile.getOriginalFileName());
                ret.set((Object)"type", (Object)fileName.split("\\.")[1]);
                ret.set((Object)"size", (Object)upfile.getFile().length());
                this.renderJson(ret);
            }
        }
    }
}

