/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.controller;

import com.google.inject.Inject;
import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;
import java.util.List;

@ControllerDefine(key="/dept", summary="\u90e8\u95e8\u7ba1\u7406", view="/")
@AuthRequire.Logined
public class DeptController
extends EController {
    @Inject
    DeptService ds;

    public void index() {
        String compId = this.attr().getComp().getId();
        Dept rootDept = this.ds.getRootDept(compId);
        List<Dept> depts = this.ds.getAllDepts(compId);
        this.setAttr("pid", this.getPara("pid", rootDept.getId()));
        this.setAttr("rootDept", (Object)rootDept);
        this.setAttr("depts", depts);
        this.render("dept.html");
    }

    public void add() {
        String compId = this.attr().getComp().getId();
        String pid = this.getPara("pid");
        String caption = this.getPara("caption");
        String summary = this.getPara("summary");
        Integer level = this.getParaToInt("level", 1);
        Dept parent = (Dept)this.ds.findById(pid);
        Dept last = this.ds.getLastDept(compId, pid);
        Integer sort = last == null ? 1 : last.getSort() + 1;
        String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix((int)sort, (int)3));
        Dept dept = new Dept();
        dept.setCompId(compId);
        dept.setPid(pid);
        dept.setCaption(caption);
        dept.setSummary(summary);
        dept.setLevel(level);
        dept.setSort(sort);
        dept.setPath(path);
        this.ds.addDept(dept);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void modify() {
        String id = this.getPara("id");
        Dept dept = (Dept)this.ds.findById(id);
        String pid = dept.getPid();
        String caption = this.getPara("caption");
        String summary = this.getPara("summary");
        Integer level = this.getParaToInt("level", 1);
        dept.setCaption(caption);
        dept.setSummary(summary);
        dept.setLevel(level);
        this.ds.modifyDept(dept);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void remove() {
        String compId = this.attr().getComp().getId();
        String pid = this.getPara("pid");
        String ids = this.getPara("ids");
        this.ds.removeDepts(compId, ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }

    public void sort() {
        String compId = this.attr().getComp().getId();
        String pid = this.getPara("pid");
        String opt = this.getPara("opt");
        String ids = this.getPara("ids");
        this.ds.sort(compId, pid, opt, ids);
        this.redirect(this.attr().getCtrl() + "?pid=" + pid);
    }
}

