package itez.plat.wrapper.launch;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.eclipse.jetty.util.resource.ResourceCollection;

import itez.kit.server.LocalServer_Jetty;

public class PlatServer extends LocalServer_Jetty {

	@Override
	protected void setBaseResources(String webAppDir) {
		try {
			String userDir = System.getProperty("user.dir");
			String metaDir = "/src/main/resources/META-INF/resources";
			List<String> resources = new ArrayList<String>();
			resources.add(webAppDir);
			resources.add(userDir + "/../../jwinner-base" + metaDir);

			MavenXpp3Reader reader = new MavenXpp3Reader();
			FileReader myPom = new FileReader(userDir + File.separator + "pom.xml");
	        Model model = reader.read(myPom);
	        List<Dependency> ds = model.getDependencies();
	        ds.forEach(d -> {
	        	String artifactId = d.getArtifactId();
	        	if(!artifactId.equals("jwinner-base")){
					resources.add(userDir + "/../" + artifactId + metaDir);
	        	}
	        });
			String[] resourcesArr = resources.toArray(new String[resources.size()]);
			context.setBaseResource(new ResourceCollection(resourcesArr));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
