package itez.plat.wrapper.interceptor;

import java.util.List;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.EContext;
import itez.core.runtime.service.ServiceManager;
import itez.core.runtime.session.EAttr;
import itez.core.runtime.session.ESessionBase;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.Menu;
import itez.plat.base.service.MenuService;

public class MenuInterceptor implements Interceptor {
	
	@Override
	public void intercept(Invocation inv) {
		EController controller = (EController)inv.getController();
		ESessionBase session = controller.session();
		EAttr attr = EContext.getAttr();
		
		final String menuActiveKey = "_m_";
		final String menuListKey = "_ms_";
		
		String clickMenu = controller.getPara(menuActiveKey);
		if(EStr.notEmpty(clickMenu)) session.setAttribute(menuActiveKey, clickMenu);
		clickMenu = session.getAttr(menuActiveKey);
		if(clickMenu != null) attr.setItem(menuActiveKey, clickMenu);
		
		MenuService ms = ServiceManager.me.getService(MenuService.class);
		List<Menu> menus = ms.getCompMenus(attr.getComp().getId());
		if(menus != null) attr.setItem(menuListKey, menus);
		
		inv.invoke();
	}

}
