package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EHttp;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.core.runtime.EContext;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Dept;
import itez.plat.base.model.Post;
import itez.plat.base.model.User;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.PostService;
import itez.plat.base.service.UserIOService;
import itez.plat.base.service.UserServiceTm3;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserServiceTm3Impl extends EModelService<User> implements UserServiceTm3 {
	
	@Inject
	UserIOService uioService;
	
	@Inject
	DeptService deptService;
	
	@Inject
	PostService postService;
	
	/**
	 * 根据TM3 Uid返回用户信息
	 * @param uid
	 * @return
	 */
	@Cache.able
	public User getByTm3Uid(String uid){
		Querys qs = Querys.and(Query.eq("tmid", uid));
		return selectFirst(qs);
	}
	
	/**
	 * 将TM3用户信息添加到本地用户表
	 * @param retJson
	 * @return
	 */
	public User addByTm3User(User user, String loginPass){
		uioService.addUser(user, loginPass);
		return user;
	}
	
	/**
	 * 修改本地存储的TM3用户信息
	 * @param user
	 * @param loginPass
	 * @return
	 */
	public User updateByTm3User(User user, String loginPass){
		uioService.modifyUser(user, loginPass);
		return user;
	}
	
	/**
	 * 同步TM3的机构信息到本地
	 * @param deptId
	 * @param deptCaption
	 */
	public Dept syncDeptByTm3(String deptId, String deptCaption){
		Dept rootDept = deptService.createRootDept();
		Dept dept = deptService.findByTmid(deptId);
		Dept last = deptService.getLastDept(rootDept.getId());
		Integer sort = last == null ? 1 : last.getSort() + 1;
		String path = String.format("%s_%s", rootDept.getPath(), EStr.addPrefix(sort, 3));
		if(dept == null){
			dept = new Dept();
			dept.setPid(rootDept.getId());
			dept.setCaption(deptCaption);
			dept.setLevel(0);
			dept.setTmid(deptId);
			dept.setSort(sort);
			dept.setPath(path);
			deptService.addDept(dept);
		}
		return dept;
	}
	
	/**
	 * 同步TM3的岗位信息到本地
	 * @param postId
	 * @param postCaption
	 */
	public Post syncPostByTm3(String postId, String postCaption){
		Post post = postService.findByTmid(postId);
		if(post == null){
			post = new Post();
			post.setTmid(postId);
			post.setCaption(postCaption);
			post.setSort(0);
			post.setSign("");
			postService.addPost(post);
		}
		return post;
	}
	
	/**
	 * 验证TM3登录账号
	 * @param loginName
	 * @param loginPass
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ERet loginCheck(String loginName, String loginPass){
		String service = "/plat/user";
		String action = "Vali";
		String url = String.format("%s%s?action=%s&loginName=%s&loginPass=%s", EProp.TM_Url, service, action, loginName, loginPass);
		String res = EHttp.me.get(url);
		if(EStr.notEmpty(res)){
			ERet resJson = ERet.parse(res);
			if(resJson.isOk()){
				ERet ret = ERet.ok("TM3账号验证通过：" + EProp.TM_Url);
				
				/**
				 * 处理详细的用户信息
				 */
				JSONObject userObj = (JSONObject) resJson.get("user");
				String uid = userObj.getObject("id", String.class);
				String uname = userObj.getObject("name", String.class);
				Map<String, Object> role = userObj.getObject("role", Map.class);
				Integer level = (Integer) role.getOrDefault("level", "1");
				String qxStr = (String) role.get("qxStr");
				Map<String, Object> dept = userObj.getObject("logicOrg", Map.class);
				String deptId = (String) dept.get("dm");
				String deptCaption = (String) dept.get("mc");
				Dept deptNative = syncDeptByTm3(deptId, deptCaption);
				String postId = userObj.getObject("gwid", String.class);
				String postCaption = userObj.getObject("gwmc", String.class);
				Post postNative = syncPostByTm3(postId, postCaption);
				User user = getByTm3Uid(uid);
				if(user != null){
					user.setLevel(level == 6 ? 1 : 0);
					user.setRoleIds(qxStr);
					user.setDeptId(deptNative.getId());
					user.setPostId(postNative.getId());
					user = updateByTm3User(user, loginPass);
				}else{
					user = new User();
					user.setTmid(uid);
					user.setDomain($domain());
					user.setType(1);
					user.setCaption(uname);
					user.setLoginName(loginName);
					user.setLevel(level == 6 ? 1 : 0);
					user.setRoleIds(qxStr);
					user.setDeptId(deptNative.getId());
					user.setPostId(postNative.getId());
					user = addByTm3User(user, loginPass);
				}
				
				//将当前登录用户的岗位首页模板ID存入Session
				EContext.getSession().setAttribute("postTempId", resJson.get("postTempId"));
				//将当前登录用户级别存入Session
				EContext.getSession().setAttribute("TM_Level", level);
				//将当前登录用户的MyOrg信息存入Session
				EContext.getSession().setAttribute("TM_MyOrg", userObj.getObject("myOrg", Map.class));
				
				ret.set("user", user);
				return ret;
			}else{
				return ERet.fail(resJson.getMsg());
			}
		}else{
			return ERet.fail("连接TM3服务器失败！请稍后再试");
		}
	}

}