package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.runtime.service.Define;
import itez.plat.base.model.User;
import itez.plat.base.service.UserIOService;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserIOServiceImpl extends EModelService<User> implements UserIOService {
	
	/**
	 * 添加新用户
	 * @param user
	 * @return
	 */
	public User addUser(User user, String loginPass){
		user.setSalt(HashKit.generateSaltForSha512());
		user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		user.save();
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user){
		user.update();
		ECacheKit.remove("USER_BY_ID", user.getId());
		ECacheKit.remove("USER_BY_LOGIN", String.format("%s.%s", user.getDomain(), user.getLoginName()));
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user, String loginPass){
		user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		user.update();
		ECacheKit.remove("USER_BY_ID", user.getId());
		ECacheKit.remove("USER_BY_LOGIN", String.format("%s.%s", user.getDomain(), user.getLoginName()));
		return user;
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	public void removeUser(User user){
		user.disable();
		ECacheKit.remove("USER_BY_ID", user.getId());
		ECacheKit.remove("USER_BY_LOGIN", String.format("%s.%s", user.getDomain(), user.getLoginName()));
	}

}